<?php if(count(get_included_files()) == 1) exit("No direct script access allowed");

require_once(ABSPATH . 'wp-admin/includes/file.php');
require_once(ABSPATH . 'wp-admin/includes/plugin.php');
$plugin_data = get_plugin_data(WP_HAUN_PATH.'index.php');
$version = $plugin_data['Version'];

define("HAUN_API_DEBUG", false);

define("HAUN_TEXT_CONNECTION_FAILED", 'Server is unavailable at the moment, please try again.');
define("HAUN_TEXT_INVALID_RESPONSE", 'Server returned an invalid response, please contact support.');
define("HAUN_TEXT_VERIFIED_RESPONSE", 'Verified! Thanks for purchasing.');
define("HAUN_TEXT_PREPARING_MAIN_DOWNLOAD", 'Preparing to download main update...');
define("HAUN_TEXT_MAIN_UPDATE_SIZE", 'Main Update size:');
define("HAUN_TEXT_DONT_REFRESH", '(Please do not refresh the page).');
define("HAUN_TEXT_DOWNLOADING_MAIN", 'Downloading main update...');
define("HAUN_TEXT_UPDATE_PERIOD_EXPIRED", 'Your update period has ended or your license is invalid, please contact support.');
define("HAUN_TEXT_UPDATE_PATH_ERROR", 'Folder does not have write permission or the update file path could not be resolved, please contact support.');
define("HAUN_TEXT_MAIN_UPDATE_DONE", 'Main update files downloaded and extracted.');
define("HAUN_TEXT_UPDATE_EXTRACTION_ERROR", 'Update zip extraction failed.');
define("HAUN_TEXT_PREPARING_SQL_DOWNLOAD", 'Preparing to download SQL update...');
define("HAUN_TEXT_SQL_UPDATE_SIZE", 'SQL Update size:');
define("HAUN_TEXT_DOWNLOADING_SQL", 'Downloading SQL update...');
define("HAUN_TEXT_SQL_UPDATE_DONE", 'SQL update files downloaded.');
define("HAUN_TEXT_UPDATE_WITH_SQL_DONE", 'Application was successfully updated, please import the downloaded SQL file in your database manually.');
define("HAUN_TEXT_UPDATE_WITHOUT_SQL_DONE", 'Application was successfully updated, there were no SQL updates.');

class HaunPLuginAPI{
	private $product_id;
	private $api_url;
	private $api_key;
	private $api_language;
	private $current_version;
	private $verify_type;
	private $verification_period;
	private $current_path;
	private $root_path;
	private $license_file;
	private $asset_path;
	public function __construct(){ 
		global $version;
		$this->product_id = '6E2F5993';
		$this->api_url = 'https://apihn.haunytb.com/';
		$this->api_key = 'F6ECE63E42EB1342FC6A';
		$this->api_language = 'vietnam';
		$this->current_version = $version;
		$this->verify_type = 'non_envato';
		$this->verification_period = 90;
		$this->current_path = realpath(__DIR__);
		$this->root_path = realpath($this->current_path.'/..');
		$this->lic_path 			= ABSPATH . 'wp-admin/user';
        $this->license_file 		= $this->lic_path . '/haunytb.config';
		$this->asset_path 			= realpath($this->current_path . "/assets/files");
	}

	public function check_local_license_exist(){
		return is_file($this->license_file);
	}

	public function get_current_version(){
		return $this->current_version;
	}

	private function init_wp_fs(){
		global $wp_filesystem;
		if(false === ($credentials = request_filesystem_credentials(''))){
			return false;
		}
		if(!WP_Filesystem($credentials)){ 
			request_filesystem_credentials('');
			return false;
		}
		return true;
	}

	private function write_wp_fs($file_path, $content){
		global $wp_filesystem;
		$save_file_to = $file_path;
		if($this->init_wp_fs()){    
			if($wp_filesystem->put_contents($save_file_to, $content, FS_CHMOD_FILE)){
				return true;
			}
			else{
				return false;
			}
		}
	}

	private function read_wp_fs($file_path){
		global $wp_filesystem;
		if($this->init_wp_fs()){    
			return $wp_filesystem->get_contents($file_path);
		}
	}

	private function call_api($method, $url, $data = null){
		$wp_args = array('body' => $data);	
		$wp_args['method'] = $method;

		$this_url = site_url();
		$this_ip = getenv('SERVER_ADDR')?:
			$this->get_ip_from_third_party()?:
			gethostbyname(gethostname());

		$wp_args['headers'] = array(
			'Content-Type' => 'application/json', 
			'LB-API-KEY' => $this->api_key, 
			'LB-URL' => $this_url, 
			'LB-IP' => $this_ip, 
			'LB-LANG' => $this->api_language
		);
		$wp_args['timeout'] = 30;

		$result = wp_remote_request($url, $wp_args);

		if(is_wp_error($result)&&!HAUN_API_DEBUG){
			$rs = array(
				'status' => FALSE, 
				'message' => HAUN_TEXT_CONNECTION_FAILED
			);
			return json_encode($rs);
		}
		$http_status = $result['response']['code'];
		if($http_status != 200){
			if(HAUN_API_DEBUG){
				$temp_decode = json_decode($result['body'], true);
				$rs = array(
					'status' => FALSE, 
					'message' => ((!empty($temp_decode['error']))?
						$temp_decode['error']:
						$temp_decode['message'])
				);
				return json_encode($rs);
			}else{
				$rs = array(
					'status' => FALSE, 
					'message' => HAUN_TEXT_INVALID_RESPONSE
				);
				return json_encode($rs);
			}
		}
		return $result['body'];
	}

	public function check_connection(){
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/check_connection_ext'
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	public function get_latest_version(){
		$data_array =  array(
			"product_id"  => $this->product_id
		);
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/latest_version', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	public function activate_license($license, $client, $create_lic = true){
		$data_array =  array(
			"product_id"  => $this->product_id,
			"license_code" => $license,
			"client_name" => $client,
			"verify_type" => $this->verify_type
		);
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/activate_license', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		if(!empty($create_lic)){
			if($response['status']){
				$licfile = trim($response['lic_response']);
				$this->write_wp_fs($this->license_file, $licfile);
			}else{
				if(is_writeable($this->license_file)){
					unlink($this->license_file);
				}
			}
		}
		return $response;
	}

	public function verify_license($time_based_check = false, $license = false, $client = false){
		if(!empty($license)&&!empty($client)){
			$data_array =  array(
				"product_id"  => $this->product_id,
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
		}else{
			if(is_file($this->license_file)){
				$data_array =  array(
					"product_id"  => $this->product_id,
					"license_file" => $this->read_wp_fs($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
		} 
		$res = array('status' => TRUE, 'message' => HAUN_TEXT_VERIFIED_RESPONSE);
		if($time_based_check && $this->verification_period > 0){
			ob_start();
			if(session_status() == PHP_SESSION_NONE){
				session_start();
			}
			$type = (int) $this->verification_period;
			$today = date('d-m-Y');
			if(empty($_SESSION["2250629469f04f5"])){
				$_SESSION["2250629469f04f5"] = '00-00-0000';
			}
			if($type == 1){
				$type_text = '1 day';
			}elseif($type == 3){
				$type_text = '3 days';
			}elseif($type == 7){
				$type_text = '1 week';
			}elseif($type == 30){
				$type_text = '1 month';
			}elseif($type == 90){
				$type_text = '3 months';
			}elseif($type == 365) {
				$type_text = '1 year';
			}else{
				$type_text = $type.' days';
			}
			if(strtotime($today) >= strtotime($_SESSION["2250629469f04f5"])){
				$get_data = $this->call_api(
					'POST',
					$this->api_url.'api/verify_license', 
					json_encode($data_array)
				);
				$res = json_decode($get_data, true);
				if($res['status']==true){
					$tomo = date('d-m-Y', strtotime($today. ' + '.$type_text));
					$_SESSION["2250629469f04f5"] = $tomo;
				}
			}
			session_write_close();
			ob_end_clean();
		}else{
			$get_data = $this->call_api(
				'POST',
				$this->api_url.'api/verify_license', 
				json_encode($data_array)
			);
			$res = json_decode($get_data, true);
		}
		return $res;
	}

	public function deactivate_license($license = false, $client = false){
		if(!empty($license)&&!empty($client)){
			$data_array =  array(
				"product_id"  => $this->product_id,
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
		}else{
			if(is_file($this->license_file)){
				$data_array =  array(
					"product_id"  => $this->product_id,
					"license_file" => $this->read_wp_fs($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
		}
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/deactivate_license', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		if($response['status']){
			if(is_writeable($this->license_file)){
				unlink($this->license_file);
			}
		}
		return $response;
	}

	public function check_update(){
		$data_array =  array(
			"product_id"  => $this->product_id,
			"current_version" => $this->current_version
		);
		$get_data = $this->call_api(
			'POST',
			$this->api_url.'api/check_update', 
			json_encode($data_array)
		);
		$response = json_decode($get_data, true);
		return $response;
	}

	public function download_update($update_id, $type, $version, $license = false, $client = false){ 
		if(!empty($license)&&!empty($client)){
			$data_array =  array(
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
		}else{
			if(is_file($this->license_file)){
				$data_array =  array(
					"license_file" => $this->read_wp_fs($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
		}
		ob_end_flush(); 
		ob_implicit_flush(true);  
		$version = str_replace(".", "_", $version);
		ob_start();
		$source_size = $this->api_url."api/get_update_size/main/".$update_id; 
		echo LB_TEXT_PREPARING_MAIN_DOWNLOAD."<br>";
		ob_flush();
		echo LB_TEXT_MAIN_UPDATE_SIZE." ".$this->get_remote_filesize($source_size)." ".LB_TEXT_DONT_REFRESH."<br>";
		ob_flush();
		$temp_progress = '';
		$source = $this->api_url."api/download_update/main/".$update_id; 
		$wp_args = array('body' => json_encode($data_array));	
		$wp_args['method'] = 'POST';
		$this_url = site_url();
		$this_ip = getenv('SERVER_ADDR')?: $this->get_ip_from_third_party()?: gethostbyname(gethostname());
		$wp_args['headers'] = array(
			'Content-Type' => 'application/json', 
			'LB-API-KEY' => $this->api_key, 
			'LB-URL' => $this_url, 
			'LB-IP' => $this_ip, 
			'LB-LANG' => $this->api_language
		);
		$wp_args['timeout'] = 30;
		echo LB_TEXT_DOWNLOADING_MAIN."<br>";
		ob_flush();
		$result = wp_remote_request($source, $wp_args);
		if(is_wp_error($result)){
			exit("<br>".LB_TEXT_CONNECTION_FAILED);
		}
		$data = $result['body'];
		$http_status = $result['response']['code'];
		if($http_status != 200){
			if($http_status == 401){
				exit("<br>".LB_TEXT_UPDATE_PERIOD_EXPIRED);
			}else{
				exit("<br>".LB_TEXT_INVALID_RESPONSE);
			}
		}
		$destination = $this->root_path."/update_main_".$version.".zip"; 
		$file = $this->write_wp_fs($destination, $data);
		if(!$file){
			exit("<br>".LB_TEXT_UPDATE_PATH_ERROR);
		}
		ob_flush();
		$zip = new ZipArchive;
		$res = $zip->open($destination);
		if($res === TRUE){
			$zip->extractTo($this->root_path."/"); 
			$zip->close();
			unlink($destination);
			echo LB_TEXT_MAIN_UPDATE_DONE."<br><br>";
			ob_flush();
		}else{
			echo LB_TEXT_UPDATE_EXTRACTION_ERROR."<br><br>";
			ob_flush();
		}
		if($type == true){
			$source_size = $this->api_url."api/get_update_size/sql/".$update_id; 
			echo LB_TEXT_PREPARING_SQL_DOWNLOAD."<br>";
			ob_flush();
			echo LB_TEXT_SQL_UPDATE_SIZE." ".$this->get_remote_filesize($source_size)." ".LB_TEXT_DONT_REFRESH."<br>";
			ob_flush();
			$temp_progress = '';
			$source = $this->api_url."api/download_update/sql/".$update_id;
			$wp_args = array('body' => json_encode($data_array));	
			$wp_args['method'] = 'POST';
			$this_url = site_url();
			$this_ip = getenv('SERVER_ADDR')?:
				$this->get_ip_from_third_party()?:
				gethostbyname(gethostname());
			$wp_args['headers'] = array(
				'Content-Type' => 'application/json', 
				'LB-API-KEY' => $this->api_key, 
				'LB-URL' => $this_url, 
				'LB-IP' => $this_ip, 
				'LB-LANG' => $this->api_language
			);
			$wp_args['timeout'] = 30;
			echo LB_TEXT_DOWNLOADING_SQL."<br>";
			ob_flush();
			$result = wp_remote_request($source, $wp_args);
			if(is_wp_error($result)){
				exit(LB_TEXT_CONNECTION_FAILED);
			}
			$data = $result['body'];
			$http_status = $result['response']['code'];
			if($http_status!=200){
				exit(LB_TEXT_INVALID_RESPONSE);
			}
			$destination = $this->root_path."/update_sql_".$version.".sql"; 
			$file = $this->write_wp_fs($destination, $data);
			if(!$file){
				exit(LB_TEXT_UPDATE_PATH_ERROR);
			}
			echo LB_TEXT_SQL_UPDATE_DONE."<br><br>";
			echo LB_TEXT_UPDATE_WITH_SQL_DONE;
			ob_flush();
		}else{
			echo LB_TEXT_UPDATE_WITHOUT_SQL_DONE;
			ob_flush();
		}
		ob_end_flush(); 
	}
	private function get_ip_from_third_party(){
		$wp_args = array('method' => 'GET');	
		$wp_args['timeout'] = 30;
		$result = wp_remote_request('http://ipecho.net/plain', $wp_args);
		if(is_wp_error($result)){
			return false;
		}
		return $result['body'];
	}
	private function get_remote_filesize($url){
		$wp_args = array('method' => 'HEAD');	
		$this_url = site_url();
		$this_ip = getenv('SERVER_ADDR')?:
			$this->get_ip_from_third_party()?:
			gethostbyname(gethostname());
		$wp_args['headers'] = array(
			'Content-Type' => 'application/json', 
			'LB-API-KEY' => $this->api_key, 
			'LB-URL' => $this_url, 
			'LB-IP' => $this_ip, 
			'LB-LANG' => $this->api_language
		);
		$wp_args['timeout'] = 30;
		$result = wp_remote_request($url, $wp_args);
		if(is_wp_error($result)){
			return false;
		}
		$filesize = $result['headers']['content-length'];
		if ($filesize){
			switch ($filesize){
				case $filesize < 1024:
					$size = $filesize .' B'; break;
				case $filesize < 1048576:
					$size = round($filesize / 1024, 2) .' KB'; break;
				case $filesize < 1073741824:
					$size = round($filesize / 1048576, 2) . ' MB'; break;
				case $filesize < 1099511627776:
					$size = round($filesize / 1073741824, 2) . ' GB'; break;
			}
			return $size; 
		}
	}
}
class HNPluginGetUpdate extends HaunPLuginAPI {
	public function getUpdate($update_id, $has_sql, $version, $license = false, $client = false) {
        if (!empty($license) && !empty($client)) {
            $data_array =  array(
				"license_file" => null,
				"license_code" => $license,
				"client_name" => $client
			);
        } else {
            if(is_file($this->license_file)){
				$data_array =  array(
					"license_file" => $this->read_wp_fs($this->license_file),
					"license_code" => null,
					"client_name" => null
				);
			}else{
				$data_array =  array();
			}
        }
        ob_end_flush(); 
		ob_implicit_flush(true);
        $version = str_replace(".", "_", $version);
        ob_start();
		$source_size = $this->api_url."api/get_update_size/main/".$update_id; 
        $temp_progress = '';
        $ch = curl_init();
		$source = $this->api_url."api/download_update/main/".$update_id; 
        curl_setopt($ch, CURLOPT_URL, $source);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_array);
        $this_url = site_url();
        $this_ip = getenv("SERVER_ADDR") ?: $this->get_ip_from_third_party() ?: gethostbyname(gethostname());
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('LB-API-KEY: '.$this->api_key, 'LB-URL: ' . $this_url, 'LB-IP: ' . $this_ip));
        curl_setopt($ch, CURLOPT_NOPROGRESS, false);
        curl_setopt($ch, CURLOPT_PROGRESSFUNCTION, [$this, 'progress']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $data = curl_exec($ch);
        $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_status != 200) {
            if ($http_status == 401) {
                curl_close($ch);
                exit("<br> Thời gian cập nhật của bạn đã kết thúc hoặc giấy phép của bạn không hợp lệ, vui lòng liên hệ với bộ phận hỗ trợ.");
            }
            curl_close($ch);
            exit("<br> Máy chủ trả lại phản hồi không hợp lệ, vui lòng liên hệ với bộ phận hỗ trợ..");
        }
        curl_close($ch);
        if (!is_dir(HAUN_DOWNLOAD_PART)) {
            mkdir(HAUN_DOWNLOAD_PART, 511, true);
        }
        if (!chmod(HAUN_DOWNLOAD_PART, 511)) {
            chmod(HAUN_DOWNLOAD_PART, 511);
        }
        $file = fopen(HAUN_DOWNLOAD_PART . '/index.php', 'w+');
        if (!$file) {
            exit('<br> Thư mục không có quyền ghi hoặc không thể giải quyết đường dẫn tệp cập nhật, vui lòng liên hệ với bộ phận hỗ trợ.');
        }
        fwrite($file, '<?php // Silence is golden.');
        fclose($file);
        $destination = HAUN_DOWNLOAD_PART."/update_main_".$version.".zip";
        $file = fopen($destination, "w+");
        if (!$file) {
            exit("<br> Thư mục không có quyền ghi hoặc không thể giải quyết đường dẫn tệp cập nhật, vui lòng liên hệ với bộ phận hỗ trợ.");
        }
        fputs($file, $data);
        fclose($file);
        $_obfuscated_0D282F2A1E382B2E293D09363021402410330730131B32_ = [
			"version" => str_replace(["_", "v"], [".", ""], $version), 
			"details_url" => "http://example.com/version-2.0-details.html", 
			"download_url" => home_url("wp-content/haun-update-files/update_main_".$version.".zip")
			];
        $fp = fopen(HAUN_DOWNLOAD_PART . "/plugin_update_details.json", "w+");
        fwrite($fp, json_encode($_obfuscated_0D282F2A1E382B2E293D09363021402410330730131B32_, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        fclose($fp);
        ob_end_flush();
    }

    private function progress($resource, $download_size, $downloaded, $upload_size, $uploaded) {
        if ($download_size == 0) {
            $progress = 0;
        } else {
            $progress = round($downloaded * 100 / $download_size);
        }
        if ($prev < $progress) {
            $prev = $progress;
            $fp = fopen($this->asset_path . '/progress.txt', "w");
            fputs($fp, $progress . "\n");
            fclose($fp);
        }
    }
    
}

function hnplugin_download_update() {
	$update_id = sanitize_text_field($_POST['update_id']);
	$has_sql = sanitize_text_field($_POST['has_sql']);
	$version = sanitize_text_field($_POST['version']);
	$hngetupdate = new HNPluginGetUpdate();
    $hngetupdate->download_update($update_id, $has_sql, $version);
	wp_die('Downloaded!');
}

function hnplugin_check_update() {
	global $pluginapi;
	delete_transient('haun_license_next_update_check');
	$haun_license = $pluginapi->check_update();
	wp_send_json($haun_license);
}

function hnplugin_reset_percentage() {
	global $pluginapi;
	$fp = fopen($pluginapi->asset_path . '/progress.txt', 'w');
	fputs($fp, '0');
	fclose($fp);
	wp_die('Done!');
}

function hnplugin_show_update_notice(){
	global $pluginapi,$lb_update_res;
	$update_notification = '<tr class="active"><td colspan="4" style="padding: 0px;"><div class="update-message notice inline notice-warning notice-alt" style="margin: 3px"><p style="margin: 5px;"><b>Đã Có Phiên Bản Mới '.$lb_update_res['version'].' Cho Plugin HauNYTB . Vui Lòng </b><a href="admin.php?page=haun-plugin&tab=kich-hoat" style="text-decoration: underline;">Cập Nhật</a></p></div></td></tr>';
	echo $update_notification;
}

function hnplugin_show_license_notice(){
	$license_notification = '<tr class="active"><td colspan="4" style="padding: 0px;"><div class="notice notice-error inline notice-alt" style="margin: 3px"><p style="margin: 5px;"><b>Vui lòng nhập mã giấy phép của bạn để sử dụng plugin.</b> Vui Lòng </b><a href="admin.php?page=haun-plugin&tab=kich-hoat" style="text-decoration: underline;">Kích Hoạt</a></p></div></td></tr>';
  	echo $license_notification;
}

function hnplugin_add_settings_link($links){
	$settings_link = '<a href="https://t.me/Haunytb">Telegram</a>';
	array_push($links, $settings_link);
	return $links;
}

function hnplugin_activate_license() {
	global $pluginapi;
	$name 	 = isset($_POST['hnlicense_name']) ? sanitize_text_field($_POST['hnlicense_name']) : '';
	$apicode = isset($_POST['hnlicense_key']) ? sanitize_text_field($_POST['hnlicense_key']) : '';
	if(!empty($name)&&!empty($apicode)){
		$lb_activate_res = $pluginapi->activate_license($apicode,$name);
		wp_send_json($lb_activate_res);
	} else {
		wp_send_json(['status' => false, 'message' => 'Không Được Để Trống Tên Hoặc Khoá Kích Hoạt']);
	}
}

function hnplugin_deactivate_license(){
	global $pluginapi;
	$lb_deactivate_res = $pluginapi->deactivate_license();
	wp_send_json($lb_deactivate_res);
}

function haun_check_license_details() {
	global $pluginapi;
	$license_data = $pluginapi->verify_license();
	wp_send_json($license_data);
}

// Actions & Filters
add_action('wp_ajax_hnplugin_download_update', 'hnplugin_download_update');
add_action('wp_ajax_hnplugin_check_update', 'hnplugin_check_update');
add_action('wp_ajax_hnplugin_reset_percentage', 'hnplugin_reset_percentage');
add_action('wp_ajax_hnplugin_activate_license', 'hnplugin_activate_license');
add_action('wp_ajax_hnplugin_deactivate_license', 'hnplugin_deactivate_license');
add_action('wp_ajax_haun_check_license_details', 'haun_check_license_details');
add_filter("plugin_action_links_hnplugins/index.php", 'hnplugin_add_settings_link');

$pluginapi = new HaunPLuginAPI();
$lb_verify_res = $pluginapi->verify_license();
$lb_update_res = $pluginapi->check_update();

if($lb_update_res['status'] == '1'){
	$phienban = version_compare($version, $lb_update_res['version']);
	if($phienban < 0){ 
		add_action("after_plugin_row_hnplugins/index.php", 'hnplugin_show_update_notice', 10, 3);
	}
}

if(!$lb_verify_res['status']){ 
	add_action("after_plugin_row_hnplugins/index.php", 'hnplugin_show_license_notice', 10, 3);
}

//////////////////////////////////////////
//           PHẦN CODER
/////////////////////////////////////////
class cURL {
	var $headers;
	var $user_agent;
	var $compression;
	var $proxy;
	var $proxyauth;
	function __construct($cookies=TRUE,$compression='gzip',$proxy='180.93.139.134:64485', $proxyauth='oDUHUDHNDP:svGOBueHtN4T79K178') {
		$this->headers[] = 'Accept: image/gif, image/x-bitmap, image/jpeg, image/pjpeg';
		$this->headers[] = 'Connection: Keep-Alive';
		$this->headers[] = 'Content-type: application/x-www-form-urlencoded;charset=UTF-8';
		$this->user_agent = 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36 OPR/38.0.2220.41';
		$this->compression=$compression;
		$this->proxy=$proxy;
		$this->proxyauth=$proxyauth;
	}
	function getheader($url) {
			$process = curl_init($url);
			curl_setopt($process, CURLOPT_HTTPHEADER, $this->headers);
			curl_setopt($process, CURLOPT_HEADER, 1);
			curl_setopt($process, CURLOPT_USERAGENT, $this->user_agent);
			curl_setopt($process,CURLOPT_ENCODING , $this->compression);
			curl_setopt($process, CURLOPT_TIMEOUT, 30);
			curl_setopt($process, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($process,CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($process,CURLOPT_CAINFO, NULL);
			curl_setopt($process,CURLOPT_CAPATH, NULL);
			$return = curl_exec($process);
			curl_close($process);
			return $return;
		}
	function getnotproxxy($url) {
			$process = curl_init($url);	
			curl_setopt($process, CURLOPT_HTTPHEADER, $this->headers);
			curl_setopt($process, CURLOPT_HEADER, 0);
			curl_setopt($process, CURLOPT_USERAGENT, $this->user_agent);
			curl_setopt($process,CURLOPT_ENCODING , $this->compression);
			curl_setopt($process, CURLOPT_TIMEOUT, 30);
			curl_setopt($process, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($process,CURLOPT_SSL_VERIFYPEER, 0); 
			curl_setopt($process,CURLOPT_CAINFO, NULL); 
			curl_setopt($process,CURLOPT_CAPATH, NULL);
			$return = curl_exec($process);
			curl_close($process);
			return $return;
		}
	function get($url) {
		$process = curl_init($url);	
		curl_setopt($process, CURLOPT_HTTPHEADER, $this->headers);
		curl_setopt($process, CURLOPT_HEADER, 0);
		curl_setopt($process, CURLOPT_USERAGENT, $this->user_agent);
		curl_setopt($process, CURLOPT_ENCODING , $this->compression);
		curl_setopt($process, CURLOPT_TIMEOUT, 30);
		curl_setopt($process, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($process, CURLOPT_SSL_VERIFYPEER, 0); 
		curl_setopt($process, CURLOPT_CAINFO, NULL); 
		curl_setopt($process, CURLOPT_CAPATH, NULL);
		curl_setopt($process, CURLOPT_PROXY, $this->proxy);
		if ($this->proxyauth) curl_setopt($process, CURLOPT_PROXYUSERPWD, $this->proxyauth);
		$return = curl_exec($process);
		curl_close($process);
		return $return;
	}
}
$curlphim = new cURL();
$hn_config = json_decode(get_option('hn_form_settings'), true);
add_action('wp_ajax_hn_form_action', 'hn_form_action_callback');
function hn_form_action_callback(){
	$data = array(
		'leech' => isset($_POST['leech']) ? $_POST['leech'] : 0,
		'poster_size' => array(
			'width' => isset($_POST['poster_size_width']) ? $_POST['poster_size_width'] : '',
			'height' => isset($_POST['poster_size_height']) ? $_POST['poster_size_height'] : '',
		),
		'thumb_size' => array(
			'width' => isset($_POST['thumb_size_width']) ? $_POST['thumb_size_width'] : '',
			'height' => isset($_POST['thumb_size_height']) ? $_POST['thumb_size_height'] : '',
		),
		'auto_tags' => isset($_POST['auto_tags']) ? $_POST['auto_tags'] : 0,
		'text_tag' => isset($_POST['text_tag']) ? $_POST['text_tag'] : '',
	);
	$data_json = json_encode($data);
	update_option('hn_form_settings', $data_json);
	wp_send_json_success( 'Lưu Thành Công!' );
	wp_die();
}

add_action('wp_ajax_hn_form_action_auto', 'hn_form_action_callback_auto');
function hn_form_action_callback_auto(){
	$data = array(
		'autoleech' => isset($_POST['autoleech']) ? $_POST['autoleech'] : 0,
		'secret_key' => isset($_POST['secret_key']) ? $_POST['secret_key'] : '',
		'pageauto' => array(
			'pageform' => isset($_POST['hnformpage']) ? $_POST['hnformpage'] : '',
			'pageto'  => isset($_POST['hntopage']) ? $_POST['hntopage'] : '',
		),
		'hnautopage' => array(
			'autoophim' => isset($_POST['autoophim']) ? $_POST['autoophim'] : 0,
			'autoanimehay' => isset($_POST['autoanimehay']) ? $_POST['autoanimehay'] : 0,
			'urlanimehay'  => isset($_POST['urlanimehay']) ? $_POST['urlanimehay'] : '',
			'autodongphim' => isset($_POST['autodongphim']) ? $_POST['autodongphim'] : 0,
			'urldongphim'  => isset($_POST['urldongphim']) ? $_POST['urldongphim'] : '',
			'autotvhayyy'  => isset($_POST['autotvhayyy']) ? $_POST['autotvhayyy'] : 0,
			'urltvhayyy'  => isset($_POST['urltvhayyy']) ? $_POST['urltvhayyy'] : '',
			'autochillhay' => isset($_POST['autochillhay']) ? $_POST['autochillhay'] : 0,
			'urlchillhay' => isset($_POST['urlchillhay']) ? $_POST['urlchillhay'] : '',
		),
	);
	$data_json = json_encode($data);
	update_option('hn_form_auto', $data_json);
	wp_send_json_success( 'Lưu Thành Công!' );
	wp_die();
}

function create_data_haun($sourcePage, $url, $country = null) {
    global $hn_config;
    $countryList = (strpos($url, 'dongphim3s') !== FALSE) ? [['name' => $country]] : $sourcePage['movie']['country'];
    $categoryList = $sourcePage['movie']['category'];
    $movieType = $sourcePage['movie']['type'];
    $movieData = [
        'fetch_url' => $url,
        'title' => $sourcePage['movie']['name'],
        'org_title' => $sourcePage['movie']['origin_name'],
        'thumbnail' => $sourcePage['movie']['thumb_url'],
        'poster' => $sourcePage['movie']['poster_url'],
        'trailer_url' => $sourcePage['movie']['trailer_url'],
        'episode' => $sourcePage['movie']['episode_current'],
        'total_episode' => $sourcePage['movie']['episode_total'],
        'hntype' => (strpos($url, 'ophim') !== FALSE) ? 'ophim' : $sourcePage['movie']['hntype'],
        'content' => preg_replace('/\\r?\\n/s', '', $sourcePage['movie']['content']),
        'actor' => !empty($sourcePage['movie']['actor']) ? implode(',', $sourcePage['movie']['actor']) : '',
        'director' => !empty($sourcePage['movie']['director']) ? implode(',', $sourcePage['movie']['director']) : '',
        'type' => $movieType == 'single' ? 'single_movies' : 'tv_series',
        'lang' => $sourcePage['movie']['lang'],
        'showtime' => $sourcePage['movie']['showtime'],
        'year' => $sourcePage['movie']['year'],
        'status' => $sourcePage['movie']['status'],
        'duration' => $sourcePage['movie']['time'],
        'quality' => $sourcePage['movie']['quality']
    ];
	$movieData['country'] = array_map(fn($country) => strpos($country['name'], 'Phim') !== false ? $country['name'] : 'Phim ' . $country['name'], $countryList);
    $movieData['cat'] = array_map(fn($cat) => strpos($cat['name'], 'Phim') !== false ? $cat['name'] : 'Phim ' . $cat['name'], $categoryList);
    $movieData['tags'] = $hn_config['auto_tags'] != '0' ? explode('|', $hn_config['text_tag']) : [];
    $movieData['tags'][] = trim($sourcePage['movie']['origin_name']);
    $movieData['tags'] = array_merge($movieData['tags'], [trim($sourcePage['movie']['origin_name']) . ' Thuyết Minh', trim($sourcePage['movie']['name']) . ' Thuyết Minh', trim($sourcePage['movie']['name']) . ' Vietsub', trim($sourcePage['movie']['origin_name']) . ' Vietsub']);
    if ($sourcePage['movie']['chieurap']) {
        $movieData['cat'][] = 'Phim Chiếu Rạp';
    }
    if ($movieType == 'hoathinh') {
        $movieData['cat'][] = 'Phim Hoạt Hình';
        $movieData['type'] = (count(reset($sourcePage['episodes'])['server_data'] ?? []) > 1) ? 'series' : 'single';
    }
    if ($movieType == 'tvshows') {
        $movieData['cat'][] = 'Phim TV Show';
    }
    return $movieData;
}

function haun_add_posts($data){
	$director  = explode(',', sanitize_text_field($data['director']));
	$actor     = explode(',', sanitize_text_field($data['actor']));
	$cat_id    = array();
	foreach ($data['cat'] as $cat) {
		if (!category_exists($cat) && $cat != '') {
			wp_create_category($cat);
		}
		$cat_id[] = get_cat_ID($cat);
	}
	foreach ($data['tags'] as $tag) {
		if (!term_exists($tag) && $tag != '') {
			wp_insert_term($tag, 'post_tag');
		}
	}
	$formality = ($data['type'] == 'tv_series') ? 'tv_series' : 'single_movies';
	$post_data = array(
		'post_title'   		=> str_replace("'", '', $data['title']),
		'post_content' 		=> $data['content'],
		'post_status'  		=> 'publish',
		'comment_status' 	=> 'closed',
		'ping_status'  		=> 'closed',
		'post_author'  		=> get_current_user_id()
	);
	$post_id 				= wp_insert_post($post_data);
	update_post_meta($post_id, 'post_hntype', $data['hntype']);
	$hn_form_settings = json_decode(get_option('hn_form_settings'), true);
	$onoffpter	  = isset($hn_form_settings['leech'])? $hn_form_settings['leech']: '0';
	$thumb_width  = isset($hn_form_settings['thumb_size']['width']) ? $hn_form_settings['thumb_size']['width']: '300';
	$thumb_height = isset($hn_form_settings['thumb_size']['height']) ? $hn_form_settings['thumb_size']['height']: '450';
	$pter_width   = isset($hn_form_settings['poster_size']['width']) ? $hn_form_settings['poster_size']['width']: '1280';
	$pter_height  = isset($hn_form_settings['poster_size']['height']) ? $hn_form_settings['poster_size']['height']: '720';
	if($onoffpter == '1' && !empty($data['poster'])) {
		$poster_image_url = haun_save_images($data['poster'], $post_id, 'poster-'.$data['title'], false, $pter_width, $pter_height);
	}
	$thumb_image_url = haun_save_images($data['thumbnail'], $post_id, 'thumb-'.$data['title'], true, $thumb_width, $thumb_height);
	
	if (isset($data['status'])) {
		$status = HN_getStatus($data['status']);
		wp_set_object_terms($post_id, $status, 'status', false);
	}
	$post_format 				= haun_get_post_format_type($formality);
	set_post_format($post_id, $post_format);
	$post_meta_movies = array(
		'haun_movie_formality' 		=> $formality,
		'haun_movie_status'    		=> strtolower($data['status']),
		'fetch_info_url'			=> $data['fetch_url'],
		'haun_poster_url'      		=> $poster_image_url,
		'haun_thumb_url'       		=> $thumb_image_url,
		'haun_original_title'		=> $data['org_title'],
		'haun_trailer_url' 			=> $data['trailer_url'],
		'haun_runtime'				=> $data['duration'],
		'haun_rating' 				=> '',
		'haun_votes' 				=> '',
		'haun_episode'         		=> $data['episode'],
		'haun_total_episode' 		=> $data['total_episode'],
		'haun_quality'         		=> ($data['lang'] == 1) ? $data['lang'].' - '.$data['quality'] : $data['quality'],
		'haun_movie_notice' 		=> '',
		'haun_showtime_movies' 		=> $data['showtime'],
		'haun_add_to_widget' 		=> false,
		'save_poster_image' 		=> false,
		'set_reatured_image' 		=> false,
		'save_all_img' 				=> false,
		'is_adult' 					=> false,
		'is_copyright' 				=> false,
	);
	wp_set_object_terms($post_id, $director, 'director', false);
	wp_set_object_terms($post_id, $actor, 'actor', false);
	wp_set_object_terms($post_id, sanitize_text_field($data['year']), 'release', false);
	wp_set_object_terms($post_id, $data['country'], 'country', false);
	wp_set_post_terms($post_id, $data['tags']);
	wp_set_post_categories($post_id, $cat_id);
	update_post_meta($post_id, '_haun_metabox_options', $post_meta_movies);
	update_post_meta($post_id, '_edit_last', 1);
	return $post_id;
}

$onofftags	  = isset($hn_config['auto_tags']) ?: '0';
if($onofftags != '0'){
	add_action('init', 'haun_add_keywords');
	function haun_add_keywords(){
		$posts = get_posts(array(
			'posts_per_page' => 100,
			'post_type' => 'post'
		));
		foreach ($posts as $p) {
			$keywords = [];
			$post_title = strtolower($p->post_title);
			$title_words = explode(' ', $post_title);
			$keywords = array_merge($title_words, $keywords);

			if (get_the_tags($p->ID)) {
				foreach ((get_the_tags($p->ID)) as $tag) {
					$keywords[] = strtolower($tag->name);
				}
				update_post_meta($p->ID, 'rank_math_focus_keyword', implode(", ", $keywords));
			}
		}
	}
}

function plugin_get_the_ordered_terms ( $terms, $id, $taxonomy ) {
    if ( 'post_tag' != $taxonomy )
        return $terms;
    $terms = wp_cache_get($id, "{$taxonomy}_relationships_sorted");
    if ( false === $terms ) {
        $terms = wp_get_object_terms( $id, $taxonomy, array( 'orderby' => 'term_order' ) );
        wp_cache_add($id, $terms, $taxonomy . '_relationships_sorted');
    }
    $post = get_post($id);
    $title = $post->post_title;
    array_unshift($terms, (object) array(
        'name' => $title,
        'slug' => sanitize_title($title),
        'term_id' => 0,
        'term_taxonomy_id' => 0,
        'taxonomy' => $taxonomy,
        'description' => '',
        'parent' => 0,
        'count' => 0
    ));

    return $terms;
}
add_filter( 'get_the_terms', 'plugin_get_the_ordered_terms' , 10, 4 );

function haun_remove_default_image_sizes( $sizes ) { 
  unset( $sizes[ 'thumbnail' ]);      
  unset( $sizes[ 'medium' ]);          
  unset( $sizes[ 'medium_large' ]);    
  unset( $sizes[ 'large' ]);                    
  unset( $sizes['2048x2048']);
  unset( $sizes['1536x1536']);
  unset( $sizes['1040x720']);
  unset( $sizes['150x250']); 
  return $sizes;
}
add_filter( 'intermediate_image_sizes_advanced', 'haun_remove_default_image_sizes' );
add_filter( 'big_image_size_threshold', '__return_false' );

function haun_save_images($imageUrl, $post_id, $posttitle, $set_thumb = false, $width = null, $height = null) {
	global $curlphim;
    $imageUrl 	= str_replace('img.ophim1.com', 'img.hiephanhthienha.com', $imageUrl);
	$file_data 	= (strpos($imageUrl, 'animehay') !== FALSE) ? $curlphim->get($imageUrl) : $curlphim->getnotproxxy($imageUrl);
    $postname 	= sanitize_title($posttitle);
    $im_name 	= "$postname-$post_id.webp";
    $dirs 		= wp_upload_dir();
	$filetype 	= wp_check_filetype($im_name, null);
	$filename 	= $dirs['path'] . '/' . $im_name;
    file_put_contents($filename, $file_data);
	if (!empty($width) && !empty($height)) {
		$img = wp_get_image_editor($filename);
		if (!is_wp_error($img)) {
			$size = $img->get_size();
			if ($size['width'] < $width || $size['height'] < $height) {
				$img->resize($width, $height, true);
			} else if ($size['width'] > $width || $size['height'] > $height) {
				$img->resize($width, $height, true);
			}
				$img->save($filename);	
		}
	}
    $attachment = array('post_mime_type' => $filetype['type'],'guid' => $dirs['url'] . "/$im_name",'post_title' => $posttitle,'post_content' => '','post_status' => 'inherit');
	$attach_id = wp_insert_attachment($attachment, $filename, $post_id);
	$attach_data = wp_generate_attachment_metadata($attach_id, $filename);
	$set_thumb && set_post_thumbnail($post_id, $attach_id);
    wp_update_attachment_metadata($attach_id, $attach_data);
	$attach_url = wp_get_attachment_url($attach_id);
	return $attach_url;
}
// Phần Tập Phim 
function haun_update_tap($sourcePage, $post_id) {
    global $wpdb;
    $currentData = $wpdb->get_var("SELECT meta_value FROM $wpdb->postmeta WHERE meta_key='_haunmovies' AND post_id=$post_id");
    $currentData = json_decode($currentData, true);
    $newData = [];
    $server_nameleech = str_replace('Vietsub #1','O Vietsub', $sourcePage['episodes'][0]['server_name']);
    foreach ($sourcePage["episodes"] as $key => $servers) {
        $server_info = [];
        $server_info["haunmovies_server_name"] = str_replace('Vietsub #1','O Vietsub', $servers["server_name"]);
        $server_info["haunmovies_server_data"] = [];
        foreach ($servers["server_data"] as $episode) {
            $slug_array = str_replace('-', '_', sanitize_title($episode['name']));
            $episode["link_m3u8"] = str_replace('http:', 'https:', $episode["link_m3u8"]);
            $episode["link_embed"] = str_replace('http:', 'https:', $episode["link_embed"]);
            $ep_data = [];
			$typepro = (strpos($episode["link_m3u8"], 'm3u8') !== FALSE) ? 'link' : 'embed';
            $ep_data['haunmovies_ep_name'] = $episode["name"];
            $ep_data['haunmovies_ep_slug'] = sanitize_title($episode["name"]);
            $ep_data['haunmovies_ep_type'] = $typepro;
            $ep_data['haunmovies_ep_link'] = $episode["link_m3u8"];
            $ep_data['haunmovies_ep_subs'] = [];
            $ep_data['haunmovies_ep_listsv'] = [];
            $subServerData = [
                "haunmovies_ep_listsv_link" => $episode["link_embed"],
                "haunmovies_ep_listsv_type" => "embed",
                "haunmovies_ep_listsv_name" => "#Dự Phòng"
            ];
            array_push($ep_data['haunmovies_ep_listsv'], $subServerData);
            $server_info["haunmovies_server_data"][$slug_array] = $ep_data;
        }
        array_push($newData, $server_info);
    }
    if ($currentData) {
        $serverExists = false;
        foreach ($currentData as $key => $data) {
            if ($data["haunmovies_server_name"] === $server_nameleech) {
                $serverExists = true;
                $currentData[$key] = $newData[0];  
                break;
            }
        }
        if (!$serverExists) {
            array_push($currentData, $newData[0]); 
        }
    } else {
        $currentData = $newData;
    }
    update_post_meta($post_id, '_haunmovies', json_encode($currentData, JSON_UNESCAPED_UNICODE));
    return json_encode($currentData);
}


// Hết Phần Tập Phim 
function get_posts_by_meta_query() {
  $post_type = $_POST['post_type'];
  $meta_query = $_POST['meta_query'];
  if (isset($_POST['data_type']) && $_POST['data_type'] == "") {
    $posts = get_posts(array(
      'post_type' => $post_type,
      'posts_per_page' => -1,
      'fields' => 'ids',
    ));
  } else {
    $posts = get_posts(array(
      'post_type' => $post_type,
      'meta_query' => $meta_query,
      'posts_per_page' => -1,
      'fields' => 'ids',
    ));
  }
  echo json_encode($posts);
  wp_die();
}
add_action('wp_ajax_get_posts_by_meta_query', 'get_posts_by_meta_query');
add_action('wp_ajax_nopriv_get_posts_by_meta_query', 'get_posts_by_meta_query');

function delete_all_posts() {
  $hntype = $_POST['hntype'];
  $post_id = $_POST['post_id'];
  $post_title = get_the_title($post_id);
  wp_delete_post($post_id, true);
  $uploads_dir = wp_upload_dir();
  $upload_path = $uploads_dir['basedir'].'/hn_uploads/'.$hntype.'/'.$post_id;
  if (is_dir($upload_path)) {
    $files = glob($upload_path.'/*');
    foreach ($files as $file) {
      if (is_file($file)) {
        unlink($file);
      }
    }
    rmdir($upload_path);
  }
  $message = '<p>Bài viết "'.$post_title.'" đã được xóa thành công.</p>';
  echo $message;
  wp_die();
}

add_action('wp_ajax_delete_all_posts', 'delete_all_posts');
add_action('wp_ajax_nopriv_delete_all_posts', 'delete_all_posts');

function HN_getLastLog() {
	$log_path = __DIR__ . '/../../../crawl_allphim_logs';
	$log_filename = 'log_' . date('d-m-Y') . '.log';
	$log_data = $log_path.'/'.$log_filename;
	
	return array(
		'log_filename' => $log_filename,
		'log_data' => file_get_contents($log_data)
	);
}

function HN_getStatus($status) {
	$hl_status = "completed";
	switch (strtolower($status)) {
		case 'ongoing':
			$hl_status = "ongoing";
			break;
		case 'completed':
			$hl_status = "completed";
			break;
		default:
			$hl_status = "is_trailer";
			break;
	}
	return $hl_status;
}