<?php
define('HAUN_CRAWLER_TYPE_NOTHING', 0);
define('HAUN_CRAWLER_TYPE_INSERT', 1);
define('HAUN_CRAWLER_TYPE_UPDATE', 2);
define('HAUN_CRAWLER_TYPE_ERROR', 3);
define('HAUN_CRAWLER_TYPE_ADDSV', 4);
define('HAUN_CRAWLER_TYPE_NODATA', 5);
function haun_json_result($status, $post_id, $data, $list_episode, $msg, $wait, $schedule_code){
    return json_encode([
        'status'            => $status,
        'post_id'           => $post_id,
        'data'              => $data,
        'list_episode'      => $list_episode,
        'msg'               => $msg,
        'wait'              => $wait,
        'schedule_code'     => $schedule_code
    ]);
}
// Lấy Trang Các Nguồn
add_action('wp_ajax_crawl_ophimz_page', 'crawl_ophimz_page');
add_action('wp_ajax_crawl_dongphym_page', 'crawl_dongphym_page');
add_action('wp_ajax_crawl_chillhay_page', 'crawl_chillhay_page');
add_action('wp_ajax_crawl_animehay_page', 'crawl_animehay_page');
add_action('wp_ajax_crawl_tvhayyy_page', 'crawl_tvhayyy_page');
function crawl_ophimz_page(){
	echo crawl_page_handle($_POST['url'], 'ophimz');
	die();
}
function crawl_dongphym_page(){ 
	echo crawl_page_handle($_POST['url'], 'dongphym');
	die();
}
function crawl_chillhay_page(){
	echo crawl_page_handle($_POST['url'], 'chillhay');
	die();
}
function crawl_animehay_page(){
	echo crawl_page_handle($_POST['url'], 'animehay');
	die();
}
function crawl_tvhayyy_page(){
	echo crawl_page_handle($_POST['url'], 'tvhayyy');
	die();
}
function crawl_page_handle($url, $source){
    switch($source) {
        case 'ophimz':
            $sourcePage = json_decode(HAUNHelper::cURL($url));
            $listMovies = array_map(function($item) {
                return "https://ophim1.com/phim/{$item->slug}|{$item->name}|{$item->origin_name}";
            }, $sourcePage->items);
            break;
        case 'dongphym':
            $sourcePage = json_decode(HAUNHelper::cURL('http://5.104.80.118:2018/dongphimlist?url='.$url));
            $listMovies = array_map(function($item) {
                return "{$item->slug}|{$item->name}|{$item->country}";
            }, $sourcePage->items);
            break;
        case 'chillhay':
            $sourcePage = json_decode(HAUNHelper::cURL('http://5.104.80.118:2018/chillhaylist?url='.$url));
            $listMovies = array_map(function($item) {
                return "{$item->slug}|{$item->name}";
            }, $sourcePage->items);
            break;
        case 'animehay':
            $sourcePage = json_decode(animehaylist($url));
            $listMovies = array_map(function($item) {
                return "{$item->slug}|{$item->name}";
            }, $sourcePage->items);
            break;
        case 'tvhayyy':
            $sourcePage = json_decode(tvhayyylist($url));
            $listMovies = array_map(function($item) {
                return "{$item->slug}|{$item->name}";
            }, $sourcePage->items);
            break;
        default:
            return "Invalid source";
    }

    return join("\n", $listMovies);
}
// Lấy Phim Các Nguồn
add_action('wp_ajax_crawl_ophimz_movies', 'crawl_ophimz_movies');
add_action('wp_ajax_crawl_dongphym_movies', 'crawl_dongphym_movies');
add_action('wp_ajax_crawl_chillhay_movies', 'crawl_chillhay_movies');
add_action('wp_ajax_crawl_animehay_movies', 'crawl_animehay_movies');
add_action('wp_ajax_crawl_tvhayyy_movies', 'crawl_tvhayyy_movies');
function crawl_ophimz_movies(){
    [$url, $title] = explode('|', $_POST['url']);
    echo crawl_movies_handle($url, $title, 'ophimz');
    die();
}
function crawl_dongphym_movies(){
	[$url, $title, $country] = explode('|', $_POST['url']);
	echo crawl_movies_handle($url, $title, 'dongphim', $country);
	die();
}
function crawl_chillhay_movies(){
	[$url, $title, $org_title] = explode('|', $_POST['url']);
	echo crawl_movies_handle($url, $title, 'chillhay');
	die();
}
function crawl_animehay_movies(){
	[$url, $title] = explode('|', $_POST['url']);
	echo crawl_movies_handle($url, $title, 'animehay');
	die();
}
function crawl_tvhayyy_movies(){
	[$url, $title] = explode('|', $_POST['url']);
	echo crawl_movies_handle($url, $title, 'tvhayyy');
	die();
}
function crawl_movies_handle($url, $title, $service, $country = null){ 
    try {
        global $wpdb;
        $query = $wpdb->prepare("SELECT * FROM `$wpdb->posts` WHERE `post_title`=%s AND `post_type`='post' AND `post_status`='publish'", $title);
		$post = $wpdb->get_row($query);
        $post_meta = unserialize($wpdb->get_var("SELECT `meta_value` FROM `$wpdb->postmeta` WHERE `post_id`='{$post->ID}' AND `meta_key`='_haun_metabox_options'"));
        if(strpos($service, 'ophimz') !== FALSE){
			$sourcePage = json_decode(HAUNHelper::cURL($url), true);
			$nameleech  = str_replace('Vietsub #1','O Vietsub',$sourcePage['episodes'][0]['server_name']);
		}else{
			$sourcePage = json_decode(HAUNHelper::cURL('http://5.104.80.118:2018/' . $service . 'info?url='.$url), true);
			$nameleech  = $sourcePage['episodes'][0]['server_name'];
        }
        $serviceToServerKeyMap = [
			'animehay' => 'A Vietsub',
			'chillhay' => 'C Thuyết Minh',
			'dongphim' => 'D Vietsub',
			'ophimz'   => 'O Vietsub',
			'tvhayyy' => 'T Vietsub'
		];
		$serverKey = $serviceToServerKeyMap[$service] ?? 'A Vietsub';
		
        if (isset($post->post_title) || isset($post_meta['haun_original_title'])) {
            $server = $wpdb->get_row("SELECT * FROM `$wpdb->postmeta` WHERE `meta_key`='_haunmovies' AND `post_id`='{$post->ID}'");
            $haunmovies1 = json_decode($server->meta_value, true);
            $hadpro = ($haunmovies1) ? implode(',', array_column($haunmovies1, 'haunmovies_server_name')) : '';
            $count_vietsub_servers = 0;
            foreach ($haunmovies1 as $item) {
                if($item['haunmovies_server_name'] === $serverKey) {
                    $count_vietsub_servers = count($item['haunmovies_server_data']);
                }
            }
			$data = (strpos($service, 'dongphim') !== FALSE) ? create_data_haun($sourcePage, $url, $country) : create_data_haun($sourcePage, $url);
            if(strpos($hadpro, $serverKey) === false){
                $post_meta["fetch_info_url"] = $data['fetch_url'];
                $post_meta["haun_showtime_movies"] = $data['showtime'];
                update_post_meta($post->ID, '_haun_metabox_options', $post_meta);
                return haun_json_result(true, $post->ID, $data, haun_update_tap($sourcePage, $post->ID), 'Thêm Server Thành Công !', true, HAUN_CRAWLER_TYPE_ADDSV);
            } elseif(stripos($hadpro, $nameleech) !== false && count($sourcePage['episodes'][0]['server_data']) > $count_vietsub_servers) {
                $_haun_metabox_options = [
                    "haun_movie_formality"       => ($data['type'] == 'tv_series') ? 'tv_series' : 'single_movies',
                    "haun_movie_status"          => HN_getStatus($data['status']),
                    "fetch_info_url"             => $data['fetch_url'],
                    "haun_runtime"               => $data['duration'],
                    "haun_episode"               => $data['episode'],
                    "haun_total_episode"         => $data['total_episode'],
                    "haun_quality"               => $data['quality'],
                    "haun_showtime_movies"       => $data['showtime']
                ];
                update_post_meta($post->ID, '_haun_metabox_options', $_haun_metabox_options);
                return haun_json_result(true, $post->ID, $data, haun_update_tap($sourcePage, $post->ID), 'Cập Nhật Tập Thành Công!', true, HAUN_CRAWLER_TYPE_UPDATE);
            } else {
                return haun_json_result(false, null, null, [], 'Không Cần Cập Nhật!', false, HAUN_CRAWLER_TYPE_NOTHING);
            }
        } elseif(!empty($sourcePage['episodes'][0]['server_data']) && !empty($sourcePage)) {
            $data = (strpos($service, 'dongphim') !== FALSE) ? create_data_haun($sourcePage, $url, $country) : create_data_haun($sourcePage, $url);
            $post_id = haun_add_posts($data);
            return haun_json_result(true, $post_id, $data, haun_update_tap($sourcePage, $post_id), 'Leech Thành Công!', true, HAUN_CRAWLER_TYPE_INSERT);
        } else {
            return haun_json_result(false, null, null, null, 'Leech Thất Bại . Không Có Dữ Liệu!', false, HAUN_CRAWLER_TYPE_NODATA);
        }
    } catch (Exception $e) {
        return haun_json_result(false, null, null, null, 'Lấy Phim Lỗi', false, HAUN_CRAWLER_TYPE_ERROR);
    }
}

// Function Thêm
function animehaylist($url) {
    global $curl;
    $source = $curl->get($url);
    $animehaylist = [];
    preg_match('#<div class="movies-list">(.*?)<div class="pagination">#is', $source, $source1);
    preg_match_all('#<div class="movie-item"[^>]*>(.*?)<\/a>\s*<\/div>#is', $source1[1], $content0);
    foreach ($content0[0] as $linkimg) {
        preg_match('#<a href="(.*?)" title=#is', $linkimg, $slug);
        preg_match('#<div class="name-movie">(.*?)</div>#is', $linkimg, $name);
        preg_match('#<img src="(.*?)" alt="#is', $linkimg, $images);
        $hntime = (new DateTime())->format('Y-m-d\TH:i:s.000\Z');
        $item = [
            'modified' => ['time' => $hntime],
            'name' => trim($name[1]),
            'slug' => $slug[1],
            'thumb_url' => strip_tags(str_replace('//u', '/u', $images[1]))
        ];
        $animehaylist[] = $item;
    }
    return json_encode(['status' => true, 'items' => $animehaylist], JSON_UNESCAPED_UNICODE);
}
function tvhayyylist($url) {
    $source = HAUNHelper::cURL($url);
    $tvhayyylist = [];
    preg_match('#<ul class="list-film">(.*?)<\/ul>#is', $source, $source1);
    preg_match_all('#<li>(.*?)<\/li>#is', $source1[1], $content0);
    foreach ($content0[0] as $linkimg) {
        preg_match('#<a href="(.*?)" title=#is', $linkimg, $slug);
        preg_match('#<div class="name">(.*?)</div>#is', $linkimg, $name);
        preg_match('#<div class="name2">(.*?)</div>#is', $linkimg, $name2);
        preg_match('#<img[^>]*src="(.*?)" data-original="#is', $linkimg, $images);
        $hntime = (new DateTime())->format('Y-m-d\TH:i:s.000\Z');
        $item = [
            'modified' => ['time' => $hntime],
            'name' => trim(strip_tags($name[1])),
            'slug' => $slug[1],
            'thumb_url' => strip_tags(str_replace('//u', '/u', $images[1])),
            'origin_name' => trim(strip_tags($name2[1]))
        ];
        $tvhayyylist[] = $item;
    }
    return json_encode(['status' => true, 'items' => $tvhayyylist], JSON_UNESCAPED_UNICODE);
}



