<?php 
function haun_plugin_script(){
	global $pagenow;
	if ('admin.php' == $pagenow && ($_GET['page'] == 'haun-plugin' || $_GET['page'] == 'haun-plugins')) {
		wp_enqueue_script('haun-plugin-js', HAUN_URL . '/assets/js/haunytb.js');
		wp_enqueue_style('haun-plugin-css', HAUN_URL . '/assets/css/styles.css');
		wp_localize_script('haun-plugin-license', 'haun_license', ['ajax_url' => admin_url('admin-ajax.php')]);
	} else {
		return;
	}
}
add_action('in_admin_header', 'haun_plugin_script');

function haun_plugin_menu() {
	add_menu_page( 'HNPlugin', 'HNPlugin', 'manage_options', 'haun-plugin', 'crawl_tools', 'dashicons-heart', 90 );
	add_submenu_page( 'haun-plugin', 'Leech Phim', 'Leech phim', 'manage_options', 'haun-plugin&tab=leech-phim', 'crawl_tools',  'dashicons-video-alt', 10);
	add_submenu_page( 'haun-plugin', 'Cấu hình', 'Cấu hình', 'manage_options', 'haun-plugin&tab=cau-hinh', 'crawl_tools', 'dashicons-admin-collapse', 20  );
	add_submenu_page( 'haun-plugin', 'Kích hoạt', 'Kích hoạt', 'manage_options', 'haun-plugin&tab=kich-hoat', 'crawl_tools', 'dashicons-admin-collapse', 30  );
	add_submenu_page( 'haun-plugin', 'Sản phẩm', 'Sản phẩm', 'manage_options', 'haun-plugin&tab=san-pham', 'crawl_tools', 'dashicons-admin-collapse', 40  );
}
add_action( 'admin_menu', 'haun_plugin_menu' );

function haun_plugin_remove_menu() {
    remove_submenu_page( 'haun-plugin', 'haun-plugin' );
}
add_action( 'admin_menu', 'haun_plugin_remove_menu', 999 );

function crawl_tools() {
	$tab = isset($_GET['tab']) ? $_GET['tab'] : 'leech-phim';
	?>
	<div class="wrap">
		<nav class="nav-tab-wrapper">
			<a href="?page=haun-plugin&tab=leech-phim" class="nav-tab <?php echo ($tab == 'leech-phim' ? 'nav-tab-active' : ''); ?>">Leech phim</a>
			<a href="?page=haun-plugin&tab=cau-hinh" class="nav-tab  <?php echo ($tab == 'cau-hinh' ? 'nav-tab-active' : ''); ?>">Cấu hình</a>
			<a href="?page=haun-plugin&tab=kich-hoat" class="nav-tab <?php echo ($tab == 'kich-hoat' ? 'nav-tab-active' : ''); ?>">Kích hoạt</a>
			<a href="?page=haun-plugin&tab=san-pham" class="nav-tab <?php echo ($tab == 'san-pham' ? 'nav-tab-active' : ''); ?>">Sản phẩm</a>
		</nav>
		<div class="tab-content">		
			<div class="chao_mung">
				<div class="hnpostbox">
					<div class="inside">
						Chào Mừng Bạn Đến Với <b style="color:red">HNPlugins</b> . <b style="color:red">HNPlugins</b> Là Plugin Chuyên Về Leech Các Phim Từ Nhiều Nguồn Khác Nhau<br />
						- Hàng ngày chạy tools tầm 10 đến 20 pages đầu (tùy số lượng phim được cập nhật trong ngày) để update tập mới hoặc thêm phim mới!<br />
						- Yêu Cầu URL Leech Không Có / Ở Cuối Nếu Không Leech Phim Sẽ Bị Lỗi . Ví Dụ : https://chillhay.com/phim-moi/ <br />
						- Việc Thêm Url Leech Để Tránh Sau Khi Đổi Tên Miền Vẫn Hoạt Động Bình Thường <br />
						- Hỗ Trợ Bởi Admin : <a href="https://t.me/haunytb" target="_blank">https://t.me/haunytb</a> <br />
					</div>
				</div>
			</div>
			<?php
			switch ($tab) {
				case 'leech-phim':
					haun_plugin_leech_phim();
					break;
				case 'cau-hinh':
					haun_plugin_cau_hinh();
					break;
				case 'kich-hoat':
					haun_plugin_kich_hoat();
					break;
				case 'san-pham':
					haun_plugin_san_pham();
					break;
			}
			?>
		</div>
		<div class="hnfooter">Powered By HauNYTB.COM.</div>
	</div>
	<?php
}

function haun_plugin_leech_phim() { 
	global $pluginapi,$lb_verify_res,$lb_update_res,$version;	
	$hnformauto 	= json_decode(get_option('hn_form_auto'), true);
	$secret_key		= isset($hnformauto['secret_key'])? $hnformauto['secret_key']: '' ;
	$autoleech		= isset($hnformauto['autoleech'])? $hnformauto['autoleech']: '' ;
	$pageform   	= isset($hnformauto['pageauto']['pageform']) ? $hnformauto['pageauto']['pageform']: '5';
	$pageto  		= isset($hnformauto['pageauto']['pageto']) ? $hnformauto['pageauto']['pageto']: '1';
	$autoophim   	= isset($hnformauto['hnautopage']['autoophim']) ? $hnformauto['hnautopage']['autoophim']: '';
	$autodongphim   = isset($hnformauto['hnautopage']['autodongphim']) ? $hnformauto['hnautopage']['autodongphim']: '';
	$urldongphim   	= isset($hnformauto['hnautopage']['urldongphim']) ? $hnformauto['hnautopage']['urldongphim']: 'https://dongphim3s.net/quoc-gia/trung-quoc';
	$autoanimehay   = isset($hnformauto['hnautopage']['autoanimehay']) ? $hnformauto['hnautopage']['autoanimehay']: '';
	$urlanimehay   	= isset($hnformauto['hnautopage']['urlanimehay']) ? $hnformauto['hnautopage']['urlanimehay']: 'https://animehay.fan/phim-moi-cap-nhap';
	$autotvhayyy   	= isset($hnformauto['hnautopage']['autotvhayyy']) ? $hnformauto['hnautopage']['autotvhayyy']: '';
	$urltvhayyy   	= isset($hnformauto['hnautopage']['urltvhayyy']) ? $hnformauto['hnautopage']['urltvhayyy']: 'https://tvhaye.org/phim-moi';
	$autochillhay   = isset($hnformauto['hnautopage']['autochillhay']) ? $hnformauto['hnautopage']['autochillhay']: '';
	$urlchillhay   	= isset($hnformauto['hnautopage']['urlchillhay']) ? $hnformauto['hnautopage']['urlchillhay']: 'https://chillhay.info/phim-moi';
	$schedule_log 	= HN_getLastLog();
	$kichhoat = '<div class="cardz">
			<div class="card-body">
				Yêu Cầu Khoá Kích Hoạt
			</div><br />
			<a href="admin.php?page=haun-plugin&tab=kich-hoat" class="hn-btn btn-success">Chuyển đến Kích Hoạt</a>
		</div>';
?>
	
	<div id="conten1" class="hnmenu-primary" style="display:block">
				<div class="sidebar">
					<aside class="sidebar-menu">
					  <div id="hn-menu1" class="hn-menu active">Leech OPhim</div>
					  <div id="hn-menu2" class="hn-menu">Leech ChillHay</div>
					  <div id="hn-menu3" class="hn-menu">Leech TVHAY</div>
					  <div id="hn-menu4" class="hn-menu">Leech Dongphim3s</div>
					  <div id="hn-menu5" class="hn-menu">Leech ANIMEHAY</div>
					</aside>

					<div class="sidebar-content">
					  <div id="hn-menu1-content" class="hn-menu-content active">
							<?php if($lb_verify_res['status']):?>
								<div class="crawl_main">
									<div class="header">Leech OPHIM</div>
									<div class="crawl_page">
										<b>Url OPHIM:</b> <input type="text" style="width:70%" class="input_from" name="url_ophim" value="https://ophim1.com/danh-sach/phim-moi-cap-nhat">
									</div>
									<div class="crawl_page">
										Lấy Từ <input type="number" class="input_from" name="page_from_ophim" value="876">
										Đến <input type="number" name="page_to_ophim" class="input_from" value="1">
										<div id="get_list_ophim" class="hn-btn btn-success">Lấy Phim</div>
									</div>
									<div class="crawl_page">
										Thời gian chờ đợi Ngẫu nhiên: Từ  <input type="number" name="timeout_from_ophim" class="input_from" value="">(ms) - 
										Đến <input type="number" name="timeout_to_ophim" class="input_from" value=""> (ms)
									</div>
									<div class="crawl_page">
										<div style="display: none" id="msg_ophim" class="notice notice-success">
											<p id="msg_text_ophim"></p>
										</div>
										
										<textarea rows="10" id="result_list_ophim" class="list_movies"></textarea>
										<div id="roll_movies_ophim" class="hn-btn btn-warning">Trộn Link</div>
										<div id="crawl_movies_ophim" class="hn-btn btn-success">Crawl Movies</div>

										<div style="display: none;" id="result_success_ophim" class="notice notice-success">
											<p>Crawl Thành Công</p>
											<textarea rows="10" id="list_crawl_success_ophim"></textarea>
										</div>

										<div style="display: none;" id="result_error_ophim" class="notice notice-error">
											<p>Crawl Lỗi</p>
											<textarea rows="10" id="list_crawl_error_ophim"></textarea>
										</div>
									</div>
								</div>
							<?php else: ?>
							<div class="header">Leech OPHIM</div>
								<?php echo $kichhoat; ?>	
							<?php endif; ?>
					  </div>
					  <div id="hn-menu2-content" class="hn-menu-content">
							<?php if($lb_verify_res['status']):?>
								<div class="crawl_main">
									<div class="header">Leech ChillHay</div>
									<div class="crawl_page">
										<b>Url ChillHay:</b> <input type="text" style="width:70%" class="input_from" name="url_chillhay" value="<?php echo $urlchillhay; ?>">
									</div>
									<div class="crawl_page">
										Lấy Từ <input type="number" class="input_from" name="page_from_chillhay" value="249">
										Đến <input type="number" name="page_to_chillhay" class="input_from" value="1">
										<div id="get_list_chillhay" class="hn-btn btn-success">Lấy Danh Sách</div>
									</div>
									<div class="crawl_page">
										Thời gian chờ đợi Ngẫu nhiên: Từ  <input type="number" name="timeout_from_chillhay" class="input_from" value="">(ms) - 
										Đến <input type="number" name="timeout_to_chillhay" class="input_from" value=""> (ms)
									</div>
									<div class="crawl_page">
										<div style="display: none" id="msg_chillhay" class="notice notice-success">
											<p id="msg_text_chillhay"></p>
										</div>
										<textarea rows="10" id="result_list_chillhay" class="list_movies"></textarea>
										<div id="roll_movies_chillhay" class="hn-btn btn-warning">Trộn Link</div>
										<div id="crawl_movies_chillhay" class="hn-btn btn-success">Lấy Phim</div>

										<div style="display: none;" id="result_success_chillhay" class="notice notice-success">
											<p>Lấy Thành Công</p>
											<textarea rows="10" id="list_crawl_success_chillhay"></textarea>
										</div>

										<div style="display: none;" id="result_error_chillhay" class="notice notice-error">
											<p>Lỗi</p>
											<textarea rows="10" id="list_crawl_error_chillhay"></textarea>
										</div>
									</div>
								</div>
							<?php else: ?>
								<div class="header">Leech ChillHay</div>
								<?php echo $kichhoat; ?>	
							<?php endif; ?>
					  </div>
					  <div id="hn-menu3-content" class="hn-menu-content">
							<?php if($lb_verify_res['status']):?>
									<div class="crawl_main">
										<div class="header">Leech TVHAY</div>
										<div class="crawl_page">
											<b>Url TVHAYYY:</b> <input type="text" style="width:70%" class="input_from" name="url_tvhayyy" value="<?php echo $urltvhayyy; ?>">
										</div>
										<div class="crawl_page">
											Lấy Từ <input type="number" class="input_from" name="page_from_tvhayyy" value="450">
											Đến <input type="number" class="input_from" name="page_to_tvhayyy" value="1">
											<div id="get_list_tvhayyy" class="hn-btn btn-success">Lấy Danh Sách</div>
										</div>
										<div class="crawl_page">
											Thời gian chờ đợi Ngẫu nhiên: Từ  <input type="number" name="timeout_from_tvhayyy" class="input_from" value="">(ms) - 
											Đến <input type="number" name="timeout_to_tvhayyy" class="input_from" value=""> (ms)
										</div>
										<div class="crawl_page">
											<div style="display: none" id="msg_tvhayyy" class="notice notice-success">
												<p id="msg_text_tvhayyy"></p>
											</div>
											<textarea rows="10" id="result_list_tvhayyy" class="list_movies"></textarea>
											<div id="roll_movies_tvhayyy" class="hn-btn btn-warning">Trộn Link</div>
											<div id="crawl_movies_tvhayyy" class="hn-btn btn-success">Lấy Phim</div>

											<div style="display: none;" id="result_success_tvhayyy" class="notice notice-success">
												<p>Lấy Thành Công</p>
												<textarea rows="10" id="list_crawl_success_tvhayyy"></textarea>
											</div>

											<div style="display: none;" id="result_error_tvhayyy" class="notice notice-error">
												<p>Lỗi</p>
												<textarea rows="10" id="list_crawl_error_tvhayyy"></textarea>
											</div>
										</div>
									</div>
							<?php else: ?>
								<div class="header">Leech TVHay</div>
								<?php echo $kichhoat; ?>	
							<?php endif; ?>
					  </div>
					  <div id="hn-menu4-content" class="hn-menu-content">
							<?php if($lb_verify_res['status']):?>
									<div class="crawl_main">
										<div class="header">Leech Dongphim3s</div>
										<div class="crawl_page">
											<b>Url DongPhim:</b> <input type="text" class="input_from" style="width:70%" name="url_dongphym" value="<?php echo $urldongphim; ?>">
										</div>
										<div class="crawl_page">
											Lấy Từ <input type="number" class="input_from" name="page_from_dongphym" value="1">
											Đến <input type="number" class="input_from" name="page_to_dongphym" value="1">
											<div id="get_list_dongphym" class="hn-btn btn-success">Lấy Danh Sách</div>
										</div>
										<div class="crawl_page">
											Thời gian chờ đợi Ngẫu nhiên: Từ  <input type="number" name="timeout_from_dongphym" class="input_from" value="">(ms) - 
											Đến <input type="number" name="timeout_to_dongphym" class="input_from" value=""> (ms)
										</div>
										<div class="crawl_page">
											<div style="display: none" id="msg_dongphym" class="notice notice-success">
												<p id="msg_text_dongphym"></p>
											</div>
											<textarea rows="10" id="result_list_dongphym" class="list_movies"></textarea>
											<div id="roll_movies_dongphym" class="hn-btn btn-warning">Trộn Link</div>
											<div id="crawl_movies_dongphym" class="hn-btn btn-success">Lấy Phim</div>

											<div style="display: none;" id="result_success_dongphym" class="notice notice-success">
												<p>Thành Công</p>
												<textarea rows="10" id="list_crawl_success_dongphym"></textarea>
											</div>

											<div style="display: none;" id="result_error_dongphym" class="notice notice-error">
												<p>Lỗi</p>
												<textarea rows="10" id="list_crawl_error_dongphym"></textarea>
											</div>
										</div>
								</div>
							<?php else: ?>
								<div class="header">Leech DongPhim</div>
								<?php echo $kichhoat; ?>	
							<?php endif; ?>
					  </div>
					  <div id="hn-menu5-content" class="hn-menu-content">
						<?php if($lb_verify_res['status']):?>
								<div class="crawl_main">
									<div class="header">Leech AnimeHay</div>
									<div class="crawl_page">
										<b>Url Animehay:</b> <input type="text" class="input_from" style="width:70%" name="url_animehay" value="<?php echo $urlanimehay; ?>">
									</div>
									<div class="crawl_page">
										Lấy Từ <input type="number" class="input_from" name="page_from_animehay" value="126">
										Đến <input type="number" class="input_from" name="page_to_animehay" value="1">
										<div id="get_list_animehay" class="hn-btn btn-success">Lấy Danh Sách</div>
									</div>
									<div class="crawl_page">
											Thời gian chờ đợi Ngẫu nhiên: Từ  <input type="number" name="timeout_from_animehay" class="input_from" value="">(ms) - 
											Đến <input type="number" name="timeout_to_animehay" class="input_from" value=""> (ms)
										</div>
									<div class="crawl_page">
										<div style="display: none" id="msg_animehay" class="notice notice-success">
											<p id="msg_text_animehay"></p>
										</div>
										<textarea rows="10" id="result_list_animehay" class="list_movies"></textarea>
										<div id="roll_movies_animehay" class="hn-btn btn-warning">Trộn Link</div>
										<div id="crawl_movies_animehay" class="hn-btn btn-success">Lấy Phim</div>

										<div style="display: none;" id="result_success_animehay" class="notice notice-success">
											<p>Thành Công</p>
											<textarea rows="10" id="list_crawl_success_animehay"></textarea>
										</div>

										<div style="display: none;" id="result_error_animehay" class="notice notice-error">
											<p>Lỗi</p>
											<textarea rows="10" id="list_crawl_error_animehay"></textarea>
										</div>
									</div>
							</div>
							<?php else: ?>
								<div class="header">Leech AnimeHay</div>
								<?php echo $kichhoat; ?>	
							<?php endif; ?>
					  </div>
					</div>
				</div>
			</div>
	
<?php }
function haun_plugin_cau_hinh() { ?>
	<div class="sidebar">
		<aside class="sidebar-menu">
		  <div id="hn-option1" class="hn-option active">Tuỳ Chọn Leech</div>
		  <div id="hn-option2" class="hn-option">Auto Leech</div>
		</aside>
		<div class="sidebar-content">
			<div id="hn-option1-content" class="hn-option-content active" style="display:block">
				<div class="header">Tuỳ Chọn Trong Leech Phim</div>
				<?php
					$hnformauto = json_decode(get_option('hn_form_settings'), true);
					$leech			= isset($hnformauto['leech'])? $hnformauto['leech']: '' ;
					$auto_tags 		= isset($hnformauto['auto_tags']) ? $hnformauto['auto_tags'] : '';
					$text_tag 		= isset($hnformauto['text_tag']) ? $hnformauto['text_tag']: '';
					$thumb_width  	= isset($hnformauto['thumb_size']['width']) ? $hnformauto['thumb_size']['width']: '300';
					$thumb_height 	= isset($hnformauto['thumb_size']['height']) ? $hnformauto['thumb_size']['height']: '450';
					$pter_width   	= isset($hnformauto['poster_size']['width']) ? $hnformauto['poster_size']['width']: '1280';
					$pter_height  	= isset($hnformauto['poster_size']['height']) ? $hnformauto['poster_size']['height']: '720';
					$hn_form_auto 	= json_decode(get_option('hn_form_auto'), true);
					$secret_key		= isset($hn_form_auto['secret_key'])? $hn_form_auto['secret_key']: '' ;
					$autoleech		= isset($hn_form_auto['autoleech'])? $hn_form_auto['autoleech']: '' ;
					$pageform   	= isset($hn_form_auto['pageauto']['pageform']) ? $hn_form_auto['pageauto']['pageform']: '5';
					$pageto  		= isset($hn_form_auto['pageauto']['pageto']) ? $hn_form_auto['pageauto']['pageto']: '1';
					$autoophim   	= isset($hn_form_auto['hnautopage']['autoophim']) ? $hn_form_auto['hnautopage']['autoophim']: '';
					$autodongphim   = isset($hn_form_auto['hnautopage']['autodongphim']) ? $hn_form_auto['hnautopage']['autodongphim']: '';
					$urldongphim   	= isset($hn_form_auto['hnautopage']['urldongphim']) ? $hn_form_auto['hnautopage']['urldongphim']: 'https://dongphim3s.net/quoc-gia/trung-quoc';
					$autoanimehay   = isset($hn_form_auto['hnautopage']['autoanimehay']) ? $hn_form_auto['hnautopage']['autoanimehay']: '';
					$urlanimehay   	= isset($hn_form_auto['hnautopage']['urlanimehay']) ? $hn_form_auto['hnautopage']['urlanimehay']: 'https://animehay.fan/phim-moi-cap-nhap';
					$autotvhayyy   	= isset($hn_form_auto['hnautopage']['autotvhayyy']) ? $hn_form_auto['hnautopage']['autotvhayyy']: '';
					$urltvhayyy   	= isset($hn_form_auto['hnautopage']['urltvhayyy']) ? $hn_form_auto['hnautopage']['urltvhayyy']: 'https://tvhayu.org/phim-moi';
					$autochillhay   = isset($hn_form_auto['hnautopage']['autochillhay']) ? $hn_form_auto['hnautopage']['autochillhay']: '';
					$urlchillhay   	= isset($hn_form_auto['hnautopage']['urlchillhay']) ? $hn_form_auto['hnautopage']['urlchillhay']: 'https://chillhay.info/phim-moi';
					?>
					<form id="hnform">
						<div style="display: none" id="msg" class="notice notice-success">
								<p id="msg_text"></p>
						</div>
						<div class="form-group">
							<label for="leech"><b>Leech Ảnh Poster:</b></label>
							<input type="checkbox" id="leech" name="leech" class="switcher" value="1" <?php echo $leech ? 'checked' : ''; ?>>
						</div>
						<div class="form-group">
							<label for="poster_size"><b>Kích Thước Ảnh Poster:</b></label>
							<input type="number" id="poster_size_width" name="poster_size_width" value="<?php echo $pter_width; ?>" class="hn-form-control"> X 
							<input type="number" id="poster_size_height" name="poster_size_height" value="<?php echo $pter_height; ?>" class="hn-form-control">
						 </div>
						<div class="form-group">
							<label for="thumb_size"><b>Kích Thước Ảnh Thumb:</b></label>
							<input type="number" id="thumb_size_width" name="thumb_size_width" value="<?php echo $thumb_width; ?>" class="hn-form-control"> X 
							<input type="number" id="thumb_size_height" name="thumb_size_height" value="<?php echo $thumb_height; ?>" class="hn-form-control">
						</div>
						  <div class="form-group">
							<label for="auto_tags"><b>Auto Tags RankMath SEO:</b></label>
							<input type="checkbox" id="auto_tags" name="auto_tags" class="switcher" value="1" <?php echo $auto_tags ? 'checked' : ''; ?>>
							<br /><small><i>&emsp; Yêu Cầu Cài Đặt Plugin : <a href="/wp-admin/plugin-install.php?tab=plugin-information&amp;plugin=seo-by-rank-math&amp;TB_iframe=true&amp;width=640&amp;height=500" class="thickbox">Rank Math SEO</a> - Nếu Không Sẽ Không Có Tác Dụng Với Tuỳ Chọn Này</i></small>
						  </div>
						<div class="form-group">
							<label for="text_tag"><b>Thêm Từ Khoá Vào Phim:</b></label>
							<textarea id="text_tag" name="text_tag" class="form-control"><?php echo $text_tag; ?></textarea> 
							<br /><small><i>Từ Khoá Được Cách Nhau Bởi Ký Tự </i>|<i> . Ví Dụ : HauNYTB</i>|<i>XemPhimOnline</i>|<i>Xem Phim Nhanh</i></small>
						</div>
						<button type="submit" class="hn-btn btn-success">Lưu</button>
					</form><br />
					<div class="header" style="border-top: 1px solid #c3c4c7;">Tuỳ Chọn Xoá Bài Viết</div>
					<div id="hncontent">
						<button id="delete-all-posts" data-type="" data-text="Bạn Có Muốn Xoá Tất Cả Bài Viết Không?" class="hn-btn btn-warning">Xoá Tất Cả</button>
						<button id="delete-all-chillhay" data-type="chillhay" data-text="Bạn Có Muốn Xoá Tất Cả Bài Viết Của ChillHay Không?" class="hn-btn btn-success">Xoá ChillHay</button>
						<button id="delete-all-animehay" data-type="animehay" data-text="Bạn Có Muốn Xoá Tất Cả Bài Viết Của AnimeHay Không?" class="hn-btn btn-warning">Xoá AnimeHay</button>
						<button id="delete-all-tvhayyy" data-type="tvhayyy" data-text="Bạn Có Muốn Xoá Tất Cả Bài Viết Của TVHay Không?" class="hn-btn btn-success">Xoá TVHAYY</button>
						<button id="delete-all-ophim" data-type="ophim" data-text="Bạn Có Muốn Xoá Tất Cả Bài Viết Của OPhim Không?" class="hn-btn btn-warning">Xoá OPHIM</button>
						<button id="delete-all-dongphim" data-type="dongphim" data-text="Bạn Có Muốn Xoá Tất Cả Bài Viết Của DongPhim Không?" class="hn-btn btn-success">Xoá DongPhim</button>
						<div id="ketqua-delete"></div>
					</div>
			</div>
		  <div id="hn-option2-content" class="hn-option-content" style="display:none">
				<div class="header">Tuỳ Chọn Tự Động Leech Hàng Ngày </div>
				<div class="crawl_page">
					<b>Hưỡng Dẫn Config</b>
					<div>
						<p>
							Cấu hình crontab: <code><i style="color:blueviolet">*/10 * * * *</i> cd <i style="color:blueviolet">/path/to/</i>wp-content/plugins/hnplugin/ && php -q schedule.php <i style="color:blueviolet">{secret_key}</i></code>
						</p>
						<p>

							1 Ngày Lúc 12H Trưa: <code>0 12 * * * cd <?php echo WP_HAUN_PATH; ?> && php -q schedule.php <i style="color:blueviolet"><?php echo $secret_key; ?></i></code>
							<br />
							2 Ngày Lúc 9H Sáng: <code>*/10 * * * * cd <?php echo WP_HAUN_PATH; ?> && php -q schedule.php <i style="color:blueviolet"><?php echo $secret_key; ?></i></code>
						</p>
					</div>
					<div class="notice notice-success">
						<p>File logs: <code style="color:brown"><?php echo $schedule_log['log_filename'];?></code></p>
						<textarea rows="10" id="schedule_log" class="" readonly><?php echo $schedule_log['log_data'];?></textarea>
					</div>
				</div>
				<form id="hnformauto">
					<div style="display: none" id="msg" class="notice notice-success">
							<p id="msg_text"></p>
					</div>
					<div class="form-group">
						<label for="secret_key"><b>Khoá Kích Hoạt :</b></label>
						<input type="text" id="secret_key" name="secret_key" value="<?php echo $secret_key; ?>">
					</div>
					<div class="form-group">
						<label for="leech"><b>Bật Tự Động Leech :</b></label>
						<input type="checkbox" id="autoleech" name="autoleech" class="switcher" value="1" <?php echo $autoleech ? 'checked' : ''; ?>>
					</div>
					<div class="form-group">
						<label for="hnautopage"><b>Chọn Trang Leech:</b></label><br /> 
						<div class="list-url"><b style="width:100px;"> OPHIM  </b><input type="checkbox" id="autoophim" name="autoophim" class="switcher" value="1" <?php echo $autoophim ? 'checked' : ''; ?>> </div> 
						<div class="list-url"><b style="width:100px;"> ĐỘNGPHIM3S </b><input type="checkbox" id="autodongphim" name="autodongphim" class="switcher" value="1" <?php echo $autodongphim ? 'checked' : ''; ?>> 
						<b style="width:130px;text-indent: 10px;"> - URL DongPhim : </b><input type="text" id="urldongphim" name="urldongphim" value="<?php echo $urldongphim; ?>" class="hn-input-url"> </div> 
						<div class="list-url"><b style="width:100px;">ANIMEHAY </b><input type="checkbox" id="autoanimehay" name="autoanimehay" class="switcher" value="1" <?php echo $autoanimehay ? 'checked' : ''; ?>>
						<b style="width:130px;text-indent: 10px;"> - URL AnimeHay : </b><input type="text" id="urlanimehay" name="urlanimehay" value="<?php echo $urlanimehay; ?>" class="hn-input-url"> </div> 
						<div class="list-url"><b style="width:100px;">TVHAY2 </b><input type="checkbox" id="autotvhayyy" name="autotvhayyy" class="switcher" value="1" <?php echo $autotvhayyy ? 'checked' : ''; ?>>
						<b style="width:130px;text-indent: 10px;"> - URL TVHAY2 : </b><input type="text" id="urltvhayyy" name="urltvhayyy" value="<?php echo $urltvhayyy; ?>" class="hn-input-url"> </div> 
						<div class="list-url"><b style="width:100px;">CHILLHAY </b><input type="checkbox" id="autochillhay" name="autochillhay" class="switcher" value="1" <?php echo $autochillhay ? 'checked' : ''; ?>>
						<b style="width:130px;text-indent: 10px;"> - URL CHILLHAY : </b><input type="text" id="urlchillhay" name="urlchillhay" value="<?php echo $urlchillhay; ?>" class="hn-input-url"> </div> 
					</div>
					<div class="form-group">
						<label for="formpage"><b>Chọn Trang Leech:</b></label>
						Từ Trang <input type="number" id="hnformpage" name="hnformpage" value="<?php echo $pageform; ?>" class="hn-form-control">  
						Đến Trang <input type="number" id="hntopage" name="hntopage" value="<?php echo $pageto; ?>" class="hn-form-control">
					</div>
					<button type="submit" class="hn-btn btn-success">Lưu</button>
				</form><br />
		  </div>
		</div>
	</div>
<?php }

function haun_plugin_kich_hoat() { 
	global $pluginapi,$lb_verify_res,$lb_update_res,$version;	
?>
	<div class="header">Kích Hoạt Và Cập Nhật Plugin</div>
	<div class="cardz">
		<div class="card-body">
			<?php if(!$lb_verify_res['status']){?>
					<div id="activate-license-box">
						<div id="hnactivate-statusplugin"></div>
						<p><label>Mã Kích Hoạt</label><input type="text" class="form-control" placeholder="XXXX-XXXX-XXXX-XXXX" name="hnlicense_key" size="50" value="" required></p>
						<p><label>Tên Bạn</label><input type="text" class="form-control" placeholder="Tên Bạn" name="hnlicense_name" size="50" value="" required></p>
						<div id="hnactivate-plugin" class="hn-btn btn-success" data-action="hnplugin_activate_license">Kích Hoạt</div>                                
					</div>
			<?php } else { ?>
						<?php $dashicon = $lb_verify_res['status'] == 'active' ? 'dashicons-yes-alt' : 'dashicons-dismiss'; ?>
						<div class="license-details-box">
							<ul class="license-details">
								<li>
									<span>Trạng Thái :</span>
									<span class="license_status <?php if ($lb_verify_res['status'] == 'inactive') { echo 'license_invalid'; } ?>">
										<i class="dashicons <?php echo $dashicon; ?>"></i>
										<span class="txt" style="color: #00c4ff;">
												<?php echo ($lb_verify_res['status']) ? 'Đã Kích Hoạt' : 'Chưa Kích Hoạt'; ?>
										</span>
									</span>
								</li>
								<li>
									<span>Phiên Bản Hiện Tại :</span>
									<span class="license_status">
										<span class="txt">
												<b><?php echo $version; ?></b>
										</span>
									</span>
								</li>	
							</ul> 
						</div>
						<p><div id="hndeactivate-status"></div></p>
						<div class="license-box-action">
							<?php if ($lb_verify_res['status'] == "1") { ?>
								<span class="hn-btn btn-success" id="hnupdate-license" data-action="haun_check_license_details">Update License</span>                                 
							<?php } ?>
							<div id="hndeactivate-plugin" class="hn-btn btn-warning" data-action="hnplugin_deactivate_license">Huỷ Kích Hoạt</div> 
						</div>	
						<h2 class="title" style="padding-top:10px;">Kiểm Tra Cập Nhật Plugin</h2>
						<input type="hidden" value="<?php echo esc_attr($lb_update_res['update_id']); ?>" name="update_id">
						<input type="hidden" value="<?php echo esc_attr($lb_update_res['has_sql']); ?>" name="has_sql">
						<input type="hidden" value="<?php echo esc_attr($lb_update_res['version']); ?>" name="version">
						<div id="hnplugin_notice_update"></div>
						<div id="msg"></div>
						<div id="hnplugin-check-update" class="hn-btn btn-success"> Check Update </div>
						<div id="hnplugin-download-update" class="hn-btn btn-warning"> Download and Install <?php echo $lb_update_res['version']; ?> </div>
			<?php } ?>
		</div>
	</div>			
<?php }

function haun_plugin_san_pham() { 
		$cached_result = get_transient( 'haun_plugin_san_pham' );
		if ( $cached_result ) {
			echo $cached_result;
			return;
		}
		$result = '<div class="header">Các Sản Phẩm Có Sẵn - Chúng Tôi Luôn Đặt Uy Tín Lên Hàng Đầu . <b style="color:red"> Liên Hệ <a href="https://t.me/haunytb">Admin</a> Nếu Bạn Có Thắc Mắc </b></div>
					<div class="hnlist">
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/hnvlxx.webp" alt="hnvlxx">
							<div class="hnname">HNVLXX + TOOL - 2.500.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/hnvlxx/" alt="hnvlxx">Mua SP</a>  <a class="hn-btn btn-success" href="https://vlxx.zphim.pro/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/phimmoi.webp" alt="hnphimmoi"> 
						<div class="hnname">HNPHIMMOI - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/downloads/hnphimmoi/" alt="hnphimmoi">Mua SP</a>  <a class="hn-btn btn-success" href="https://zphim.top/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/chillhay.webp" alt="hnchillhay"> 
						<div class="hnname">HNCHILLHAY - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/hnchillhay/" alt="hnchillhay">Mua SP</a>  <a class="hn-btn btn-success" href="https://zphim.pro/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/animehay.webp" alt="hnanimehay"> 
						<div class="hnname">HNANIMEHAY - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/hnanimehay/" alt="hnanimehay">Mua SP</a>  <a class="hn-btn btn-success" href="https://zzphim.top/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/phimmoichills.webp" alt="hnphimmoichill"> 
						<div class="hnname">HNPHIMCHILL - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/hnphimchills/" alt="hnphimmoichill">Mua SP</a>  <a class="hn-btn btn-success" href="https://hnphimchill.zphim.pro/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/maccms.webp" alt="hnmaccms"> 
						<div class="hnname">HNMACCMS - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/hnmaccms/" alt="hnmaccms">Mua SP</a>  <a class="hn-btn btn-success" href="https://hnmaccms.zphim.pro/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/haunytb.webp" alt="haunytb"> 
						<div class="hnname">HNHAUNYTB - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/haunytb/" alt="haunytb">Mua SP</a>  <a class="hn-btn btn-success" href="https://haunytb.zphim.pro/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/zphim.webp" alt="zphim"> 
						<div class="hnname">HNZPHIM - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/hnzphim/" alt="zphim">Mua SP</a>  <a class="hn-btn btn-success" href="https://hnzphim.zphim.pro/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon green"><span class="coming-soon-text">Themes</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/xphim.webp" alt="xphim"> 
						<div class="hnname">HNXPHIM - 2.000.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/hnxphim/" alt="zphim">Mua SP</a>  <a class="hn-btn btn-success" href="https://hnxphim.zphim.pro/">Demo Online</a><center>
					</div>
					<div class="hnitem">
						<div class="ribbon red"><span class="coming-soon-text">PHP SCRIPT</span></div>
						<img class="hnimg" src="https://haunytb.com/hnimages/firehls.webp" alt="firehls"> 
						<div class="hnname">FIREHLS - 1.500.000 VND</div>
						<center><a class="hn-btn btn-warning" href="https://haunytb.com/items/gdrive-convert-hls/" alt="zphim">Mua SP</a>  <a class="hn-btn btn-success" href="https://firehls.zphim.pro/">Demo Online</a><center>
					</div>
				</div>';
			 set_transient( 'haun_plugin_san_pham', $result, 0 );
			echo $result;		
}