<?php
require_once __DIR__ . '/../../../wp-load.php';
require_once __DIR__ . '/../../../wp-admin/includes/taxonomy.php';
require_once __DIR__ . '/../../../wp-admin/includes/image.php';
if ( !function_exists( 'get_current_screen' ) ) { 
   require_once __DIR__ . '/../../../wp-admin/includes/screen.php'; 
} 
set_time_limit(0);
include_once WP_HAUN_INC_PATH . 'func.php';
include_once WP_HAUN_INC_PATH . 'leech.php';
$hnformauto 	= json_decode(get_option('hn_form_auto'), true);
if (!isset($argv[1]) || $argv[1] !== $hnformauto['secret_key']) {
	echo 'Sai Mã Kích Hoạt';
    return;
}
if ($hnformauto['autoleech'] === 0) {
    update_option($hnformauto['autoleech'], 0);
	echo 'Chưa Kích Hoạt';
    return;
}
if($hnformauto['autoleech'] == 1){
	$pageFrom   	= isset($hnformauto['pageauto']['pageform']) ? $hnformauto['pageauto']['pageform']: '5';
	$pageTo  		= isset($hnformauto['pageauto']['pageto']) ? $hnformauto['pageauto']['pageto']: '1';
	$autoophim   	= isset($hnformauto['hnautopage']['autoophim']) ? $hnformauto['hnautopage']['autoophim']: '';
	$autodongphim   = isset($hnformauto['hnautopage']['autodongphim']) ? $hnformauto['hnautopage']['autodongphim']: '';
	$urldongphim   	= isset($hnformauto['hnautopage']['urldongphim']) ? $hnformauto['hnautopage']['urldongphim']: 'https://dongphim3s.net/quoc-gia/trung-quoc';
	$autoanimehay   = isset($hnformauto['hnautopage']['autoanimehay']) ? $hnformauto['hnautopage']['autoanimehay']: '';
	$urlanimehay   	= isset($hnformauto['hnautopage']['urlanimehay']) ? $hnformauto['hnautopage']['urlanimehay']: 'https://animehay.fan/phim-moi-cap-nhap';
	$autotvhayyy   	= isset($hnformauto['hnautopage']['autotvhayyy']) ? $hnformauto['hnautopage']['autotvhayyy']: '';
	$urltvhayyy   	= isset($hnformauto['hnautopage']['urltvhayyy']) ? $hnformauto['hnautopage']['urltvhayyy']: 'https://tvhayu.org/phim-moi';
	$autochillhay   = isset($hnformauto['hnautopage']['autochillhay']) ? $hnformauto['hnautopage']['autochillhay']: '';
	$urlchillhay   	= isset($hnformauto['hnautopage']['urlchillhay']) ? $hnformauto['hnautopage']['urlchillhay']: 'https://chillhay.info/phim-moi';
	try {
		function crawlMovies($autoFlag, $urlBase, $pageFrom, $pageTo, $siteTag, $hasCountry = false, $customUrl = false) {
			if($autoFlag == 1){
				$listMovies = array();
				for ($i=$pageFrom; $i >= $pageTo; $i--) {
					$url = $customUrl ? $urlBase . $i : "{$urlBase}/trang-{$i}";
					if($siteTag === 'animehay' && !$customUrl) $url .= '.html';
					$result = crawl_page_handle($url, $siteTag);
					$result = explode("\n", $result);
					$listMovies = array_merge($listMovies, $result);
				}
				shuffle($listMovies);
				$countMovies = count($listMovies);
				$countDone = 0;
				$countStatus = array(0,0,0,0,0,0);
				hn_write_log("Bắt Đầu Lấy {$siteTag} Với {$countMovies} Phim");
				foreach ($listMovies as $key => $data_post) {
					if($autoFlag != 1) {
						hn_write_log("Lỗi Chưa Active {$siteTag} Auto Leech");
						return;
					}
					$data = explode('|', trim($data_post));
					$url = $data[0];
					$title = $data[1];
					$country = $hasCountry ? $data[2] : null;
					$result = crawl_movies_handle($url, $title, $siteTag, $country);
					$result = json_decode($result);
					if ($result->schedule_code == HAUN_CRAWLER_TYPE_ERROR) hn_write_log(sprintf("ERROR: %s ==>>> %s", $url, $result->msg));
					$countStatus[$result->schedule_code]++;
					$countDone++;
				}
			}
		}
		crawlMovies($autotvhayyy, $urltvhayyy, $pageFrom, $pageTo, 'tvhayyy');
		crawlMovies($autochillhay, $urlchillhay, $pageFrom, $pageTo, 'chillhay');
		crawlMovies($autoanimehay, $urlanimehay, $pageFrom, $pageTo, 'animehay');
		crawlMovies($autodongphim, $urldongphim, $pageFrom, $pageTo, 'dongphim', true);
		crawlMovies($autoophim, "https://ophim1.com/danh-sach/phim-moi-cap-nhat?page=", $pageFrom, $pageTo, 'ophimz', false, true);	
	} catch (\Throwable $th) {
		hn_write_log(sprintf("ERROR: THROW ==>>> %s", $th->getMessage()));
	}
	hn_write_log("Xong {$countDone}/{$countMovies} Phim (Không Cần Cập Nhật : {$countStatus[0]} | Thêm Thành Công : {$countStatus[1]} | Cập Nhật Thành Công : {$countStatus[2]} | Lỗi: {$countStatus[3]} | Thêm Server Thành Công: {$countStatus[4]} | Không Có Dữ Liệu: {$countStatus[5]})");
}
function hn_write_log($log_msg, $new_line = "\n") {
	$log_filename = __DIR__ . '/../../crawl_allphim_logs';
	if (!file_exists($log_filename))
	{
		mkdir($log_filename, 0777, true);
	}
	$log_file_data = $log_filename.'/log_' . date('d-m-Y') . '.log';
	file_put_contents($log_file_data, '['. date("d-m-Y H:i:s") .'] ' . $log_msg . $new_line, FILE_APPEND);
}