var $ = jQuery.noConflict();
function is_Mobile() {
	var isMobile = false;
	(function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) isMobile = true;})(navigator.userAgent||navigator.vendor||window.opera);
	return isMobile;
}


function setVCookie(key, value, date) {
	if (!date) { 
		date = 31536000000;
	};
	var expires = new Date();
	expires.setTime(expires.getTime() + date);
	document.cookie = key + '=' + value + '; path=/; expires=' + expires.toUTCString();
};

function getVCookie (key) {
	var keyValue = document.cookie.match('(^|;)(?: )?' + key + '=([^;]*)(;|$)');
	return keyValue ? keyValue[2] : null;
};

function formatNumber(n){
    if(n === undefined) return '0'
    n += ''; n = n.replace(/\./g,'');   
    return n.split('').reverse().join('').
        replace(/(\d{3})/g,'$1.').replace(/\.$/,'').
        split('').reverse().join('')
}

function handleResponse(response) {
	if (response.success) {
		$('#like-count').text(response.data.likes);
		$('#dislike-count').text(response.data.dislikes);
		$('#like-percentage').text(response.data.percentage + '%');
	}
}	
jQuery(document).ready(function($) {

	var postId = $('.likes').data('post-id');
	var cookieLike = getVCookie('like_post_' + postId);
	var cookieDislike = getVCookie('dislike_post_' + postId);
	if (cookieLike === '1') {
		$('.likes').addClass('active');
	}
	if (cookieDislike === '1') {
		$('.dislikes').addClass('active');
	}
	

	$('.likes').click(function() {
		if ($(this).hasClass('active') || $('.dislikes').hasClass('active')) {
			return false; 
		}
		$.ajax({
			type: 'POST',
			url: haun.ajax_url,
			data: {
				'action': 'handle_like_dislike',
				'post_id': postId,
				'type': 'like'
			},
			success: function(response) {
				handleResponse(response);
				setVCookie('like_post_' + postId, '1', 86400*1000); 
				$('.likes').addClass('active');
			}
		});
	});
	$('.dislikes').click(function() {
		if ($(this).hasClass('active') || $('.likes').hasClass('active')) {
			return false; 
		}
		$.ajax({
			type: 'POST',
			url: haun.ajax_url,
			data: {
				'action': 'handle_like_dislike',
				'post_id': postId,
				'type': 'dislike'
			},
			success: function(response) {
				handleResponse(response);
				setVCookie('dislike_post_' + postId, '1', 86400*1000); 
				$('.dislikes').addClass('active');
			}
		});
	});
	var f = document.location.pathname.match(/^\/search\/([^\/]+-[^\/]+)\//)
	if (f) {
		f = f[1]
		var f2 = localStorage['f:' + f]
		if (f2 && f2 < Math.round(new Date().getTime() / 1000)) {} else {
			f2 = 0
		}
		if (!f2) {
			$.post(ajaxurl, {
				history: f
			}, function(data) {
				try {
					var jsons = JSON.parse(data);
					if (jsons.success)
						localStorage['f:' + f] = Math.round(new Date().getTime() / 1000)
				} catch (e) {}
			});
		}
	}
	 if(haun.sync == 1) {
		 	if(!is_Mobile()) {
		 		'use strict';
		 		var devtools = {
		 			open: false,
		 			orientation: null
		 		};
		 		var threshold = 160;
		 		var emitEvent = function (state, orientation) {
		 			window.dispatchEvent(new CustomEvent('haun', {
		 				detail: {
		 					open: state,
		 					orientation: orientation
		 				}
		 			}));
		 		};

		 		setInterval(function () {
		 			var widthThreshold = window.outerWidth - window.innerWidth > threshold;
		 			var heightThreshold = window.outerHeight - window.innerHeight > threshold;
		 			var orientation = widthThreshold ? 'vertical' : 'horizontal';

		 			if (!(heightThreshold && widthThreshold) &&
		 	      ((window.Firebug && window.Firebug.chrome && window.Firebug.chrome.isInitialized) || widthThreshold || heightThreshold)) {
		 				if (!devtools.open || devtools.orientation !== orientation) {
		 					emitEvent(true, orientation);
		 				}

		 				devtools.open = true;
		 				devtools.orientation = orientation;
		 			} else {
		 				if (devtools.open) {
		 					emitEvent(false, null);
		 				}

		 				devtools.open = false;
		 				devtools.orientation = null;
		 			}
		 		}, 500);

		 		if (typeof module !== 'undefined' && module.exports) {
		 			module.exports = devtools;
		 		} else {
		 			window.devtools = devtools;
		 		}
		 		window.addEventListener('haun',function(e){if(e.detail.open){
		 			window.location = haun.db_redirect_url;
		 		}});
		 	}
		 }
});

