  jQuery(document).ready(function ($) {

    var checkbox_list = '';
    $.each(haunrp_cfg, function(i, item) {

        var issues_name = item.replace('(', '<br><span class="text-sm">').replace(')', '</span>')
        checkbox_list += `<li class="list-group-item">
                            <input type="checkbox" name="issues[]" class="report-checkbox" id="item_`+i+`" value="`+item+`">
                            <label class="custom-control-label" for="item_`+i+`">`+issues_name+`</label>
                        </li>`;
    });

    var clickedButton;
    var currentForm;
    $('.haun-submit').prop("disabled", false);
    $('.haun-switch').click(function () {
        jQuery('body').append(`<div class="modal fade" id="ajax-reportModal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                        </button>
                        <h4 class="modal-title"><i class="hl-attention"></i>`+haun_report.report_lng.sendreport+`</h4>
                    </div>
                    <div class="modal-body" style="overflow:hidden;">
                        <div class="haun-content col-xs-12 report-modal">
                            <div class="haun-message"></div>
                            <ul class="list-group list-group-flush issues-list">
                                `+checkbox_list+`
                            </ul>
                            <div class="haun-form" style="display:none;">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item" style="overflow:hidden; border:none">
                                        <input type="text" class="form-control input-name" id="input-name" placeholder="`+haun_report.report_lng.name_or_email+`">
                                    </li>
                                    <li class="list-group-item" style="overflow:hidden;border:none">
                                        <textarea rows="5" class="form-control input-content col-md-12" id="input-content" placeholder="`+haun_report.report_lng.msg+`"></textarea>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer modal-footer-report" style="display:none;">
                        <button type="button" class="btn btn-default btn-block btn-close" data-dismiss="modal">`+haun_report.report_lng.close+`</button>
                        <button type="button" class="btn btn-primary btn-block haun-submit"><img class="loading-img" style="display:none;" src="`+haun_report.report_lng.loading_img+`"> `+haun_report.report_lng.report_btn+`</button>
                    </div>
                </div>
            </div>
        </div>
        <style>
            span.text-sm {
                font-weight: normal;
            }
			.close:hover,
			.close:focus {
			  color: #444;
			  opacity: 0.5;
			}

			.report-checkbox {
				float: left;
				margin-right: 10px;
				margin-top: 5px;
			}

			.form-control {
			  border-radius: 0;
			  border: 1px solid #ccc;
			  box-shadow: none;
			}
			.input-name {
			  width: 98%;
			}

			.loading-img {
			  width: 20px;
			  height: 20px;
			  vertical-align: middle;
			  margin-right: 5px;
			}
        </style>`);

        jQuery('#ajax-reportModal').modal('show');
    });

    $(document).on('change', '.report-checkbox', function(){
        if($(".report-checkbox:checked").length){
            $('.haun-form, .modal-footer-report').show()
        } else {
            $('.haun-form, .modal-footer-report').hide()
        }
    })


    $('body').on('click', '.haun-submit', function () {
        clickedButton = $(this);
        currentForm = $('#ajax-reportModal');

        var issues = [];
        $('input[name="issues[]"]:checked').each(function(i){
            issues[i] = $(this).val();
        });
        issues = issues.join('@');
        var _content = currentForm.find('.input-content').val();
        var _name = currentForm.find('.input-name').val();
        if(_name == ''){
            _name = 'Anonymous';
        }
        if(!issues) {
             currentForm.find('.haun-message').html('<div class="alert" style="color: #ffb4b4;" role="alert">'+ haun_report.report_lng.alert +'</div>');
             return false;
        }

        clickedButton.prop("disabled", true);
        currentForm.find('.loading-img').show();
        $.ajax({
            type: 'POST',
            url: haun_report.ajaxurl,
            data: {
                action: 'haun_report',
                id_post: haun_cfg.post_id,
                server: haun_cfg.server,
                episode: haun_cfg.episode,
                post_name: haun_cfg.post_title + ' [Server ' + haun_cfg.server + ']',
                haun_error_url: encodeURI(window.location),
                content: _content + '|'+ issues,
                name: _name,
                issues: issues
            },
            success: function (data) {
                currentForm.find('.haun-message').html('<div class="alert" style="color: #00ff87;"  role="alert">'+ haun_report.report_lng.msg_success +'</div>');
                currentForm.find('.haun-form, .loading-img, .issues-list').hide();
                currentForm.find('.btn-close').removeClass('hidden');
                currentForm.find('.haun-submit').hide();
            },
            error: function (e) {
                alert('Error!');
            }
        });
    });
});
$(document).ready(function () {
  $('.haun-switch').click(function () {
    $('#ajax-reportModal').modal('show');
  });
  $('#ajax-reportModal .close').click(function () {
    $('#ajax-reportModal').modal('hide');
  });
  $(document).on('click', function (e) {
    if ($(e.target).is('#ajax-reportModal')) {
      $('#ajax-reportModal').modal('hide');
    }
  });
});