<?php

add_action('save_post', 'haun_download_fields_meta_box_save');
add_action('haun_after_single_content', 'haun_show_download_list', 10, 1);
add_action('haun_after_single_watch_content', 'haun_show_download_list', 10, 1);
function haun_download_quality_options() {
    $quality = array(
		'1080p' => '1080p', 
		'720p' => '720p', 
		'360p' => '360p', 
		'240p' => '240p'
	);
    return apply_filters('haun_download_quality_fields', $quality);
}

function haun_download_add_meta_boxes() {
    if (cs_get_option('enable_download_fields')) {
        add_meta_box('haun-download-fields', 'Download Fields', 'haun_download_fields_meta_box_display', 'post', 'normal', 'default');
    }
}
add_action('admin_init', 'haun_download_add_meta_boxes', 1);

function haun_download_fields_meta_box_display(){
    global $post;
    $_obfuscated_0D3C40220F2D10222B32310821390C2B1B220C27072732_ = get_post_meta($post->ID, 'haun_download_fields', true);
    $_obfuscated_0D2B0226253B123501380C0E34100F3415342E40233D22_ = haun_download_quality_options();
    wp_nonce_field("haun_download_meta_box_nonce", "haun_download_meta_box_nonce");
    echo "    <script>\r\n\t    jQuery(document).ready(function( \$ ){\r\n\t        \$( '#add-row' ).on('click', function() {\r\n\t            var row = \$( '.empty-row.screen-reader-text' ).clone(true);\r\n\t            row.removeClass( 'empty-row screen-reader-text' );\r\n\t            row.insertBefore( '#repeatable-fieldset-one tbody>tr:last' );\r\n\t            return false;\r\n\t        });\r\n\r\n\t        \$( '.remove-row' ).on('click', function() {\r\n\t            \$(this).parents('tr').remove();\r\n\t            return false;\r\n\t        });\r\n\t    });\r\n    </script>\r\n\r\n    <table id=\"repeatable-fieldset-one\" width=\"100%\">\r\n    <thead>\r\n        <tr>\r\n            <th width=\"10%\">File Name</th>\r\n            <th width=\"12%\">File Quality</th>\r\n            <th width=\"12%\">File Size</th>\r\n            <th width=\"12%\">Language</th>\r\n            <th width=\"40%\">File URL</th>\r\n            <th width=\"8%\">Click</th>\r\n            <th width=\"8%\"></th>\r\n        </tr>\r\n    </thead>\r\n    <tbody>\r\n    ";
    if ($_obfuscated_0D3C40220F2D10222B32310821390C2B1B220C27072732_) {
        foreach ($_obfuscated_0D3C40220F2D10222B32310821390C2B1B220C27072732_ as $_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_) {
            echo "\t    <tr>\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"name[]\" value=\"";
            echo $_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["name"] != "" ? esc_attr($_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["name"]) : "";
            echo "\" /></td>\r\n\r\n\t        <td>\r\n\t            <select name=\"quality[]\" style=\"width: 100%\">\r\n\t                ";
            foreach ($_obfuscated_0D2B0226253B123501380C0E34100F3415342E40233D22_ as $key => $label) {
                echo "\t                <option value=\"";
                echo $key;
                echo "\"";
                selected($_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["quality"], $key);
                echo ">";
                echo $label;
                echo "</option>\r\n\t                ";
            }
            echo "\t            </select>\r\n\t        </td>\r\n\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"size[]\" value=\"";
            echo $_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["size"] != "" ? esc_attr($_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["size"]) : "";
            echo "\" /></td>\r\n\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"languages[]\" value=\"";
            echo $_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["languages"] != "" ? esc_attr($_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["languages"]) : "";
            echo "\" /></td>\r\n\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"url[]\" value=\"";
            echo $_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["url"] != "" ? esc_attr($_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["url"]) : "http://";
            echo "\" /></td>\r\n\r\n\t        <td><input type=\"number\" class=\"widefat\" name=\"view[]\" value=\"";
            echo $_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["view"] != "" ? esc_attr($_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["view"]) : "0";
            echo "\" /></td>\r\n\r\n\t        <input type=\"hidden\" class=\"widefat\" name=\"time[]\" value=\"";
            echo $_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["time"] != "" ? esc_attr($_obfuscated_0D140A100C191E2508182C373C213E30191512310A0722_["time"]) : time();
            echo "\" />\r\n\r\n\t        <td><a class=\"button remove-row\" href=\"#\">";
            _e("Remove", "haunthemes");
            echo "</a></td>\r\n\t    </tr>\r\n\t    ";
        }
    } else {
        echo "\t    <tr>\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"name[]\" placeholder=\"File name\" /></td>\r\n\r\n\t        <td>\r\n\t            <select name=\"quality[]\" style=\"width: 100%\">\r\n\t                ";
        foreach ($_obfuscated_0D2B0226253B123501380C0E34100F3415342E40233D22_ as $key => $label) {
            echo "\t                <option value=\"";
            echo $key;
            echo "\">";
            echo $label;
            echo "</option>\r\n\t                ";
        }
        echo "\t            </select>\r\n\t        </td>\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"size[]\" value=\"\" placeholder=\"File size\" /></td>\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"languages[]\" value=\"\" placeholder=\"File language\" /></td>\r\n\t        <td><input type=\"text\" class=\"widefat\" name=\"url[]\" value=\"\" placeholder=\"File URL\" /></td>\r\n\t        <td><input type=\"number\" class=\"widefat\" name=\"view[]\" value=\"0\" placeholder=\"View count\" /></td>\r\n\t        <input type=\"hidden\" class=\"widefat\" name=\"time[]\" value=\"";
        echo time();
        echo "\" />\r\n\t        <td><a class=\"button remove-row\" href=\"#\">";
        _e("Remove", "haunthemes");
        echo "</a></td>\r\n\t    </tr>\r\n\t    ";
    }
    echo "\r\n    <!-- empty hidden one for jQuery -->\r\n    <tr class=\"empty-row screen-reader-text\">\r\n        <td><input type=\"text\" class=\"widefat\" name=\"name[]\" placeholder=\"File name\" /></td>\r\n\r\n        <td>\r\n            <select name=\"quality[]\" style=\"width: 100%\">\r\n                ";
    foreach ($_obfuscated_0D2B0226253B123501380C0E34100F3415342E40233D22_ as $key => $label) {
        echo "                <option value=\"";
        echo $key;
        echo "\">";
        echo $label;
        echo "</option>\r\n                ";
    }
    echo "            </select>\r\n        </td>\r\n\r\n        <td><input type=\"text\" class=\"widefat\" name=\"size[]\" value=\"\" placeholder=\"File size\" /></td>\r\n        <td><input type=\"text\" class=\"widefat\" name=\"languages[]\" value=\"\" placeholder=\"File language\" /></td>\r\n        <td><input type=\"text\" class=\"widefat\" name=\"url[]\" value=\"\" placeholder=\"File URL\" /></td>\r\n        <td><input type=\"number\" class=\"widefat\" name=\"view[]\" value=\"0\" placeholder=\"View count\" /></td>\r\n        <input type=\"hidden\" class=\"widefat\" name=\"time[]\" value=\"";
    echo time();
    echo "\" />\r\n\r\n        <td><a class=\"button remove-row\" href=\"#\">";
    _e("Remove", "haunthemes");
    echo "</a></td>\r\n    </tr>\r\n    </tbody>\r\n    </table>\r\n\r\n    <p><a id=\"add-row\" class=\"button\" href=\"#\">";
    _e("Add another", "haunthemes");
    echo "</a></p>\r\n    ";
}
function haun_download_fields_meta_box_save($post_id)
{
    if (!isset($_POST["haun_download_meta_box_nonce"]) || !wp_verify_nonce($_POST["haun_download_meta_box_nonce"], "haun_download_meta_box_nonce")) {
        return NULL;
    }
    if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) {
        return NULL;
    }
    if (!current_user_can("edit_post", $post_id)) {
        return NULL;
    }
    $old = get_post_meta($post_id, "haun_download_fields", true);
    $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_ = [];
    $_obfuscated_0D21012123193B3E27302A0A5B0E183B085C2323281A01_ = $_POST["name"];
    $quality = $_POST["quality"];
    $_obfuscated_0D07340E38363817191E08403D1F323C0A153D2D012622_ = $_POST["languages"];
    $_obfuscated_0D02173C40133F24393B0D2C281902403B0630382B0201_ = $_POST["url"];
    $_obfuscated_0D2F1B1B2A3E0B1301223B1B0F1C361B1B0F223F370E11_ = $_POST["size"];
    $time = $_POST["time"];
    $_obfuscated_0D2808243F3C2F3D1E021B39193F400F380A3D333B2C01_ = $_POST["view"];
    $count = count($_obfuscated_0D21012123193B3E27302A0A5B0E183B085C2323281A01_);
    for ($i = 0; $i < $count; $i++) {
        if ($_obfuscated_0D21012123193B3E27302A0A5B0E183B085C2323281A01_[$i] != "") {
            $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_[$i]["name"] = sanitize_text_field($_obfuscated_0D21012123193B3E27302A0A5B0E183B085C2323281A01_[$i]);
            $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_[$i]["languages"] = sanitize_text_field($_obfuscated_0D07340E38363817191E08403D1F323C0A153D2D012622_[$i]);
            $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_[$i]["size"] = sanitize_text_field($_obfuscated_0D2F1B1B2A3E0B1301223B1B0F1C361B1B0F223F370E11_[$i]);
            $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_[$i]["time"] = sanitize_text_field($time[$i]);
            $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_[$i]["view"] = sanitize_text_field($_obfuscated_0D2808243F3C2F3D1E021B39193F400F380A3D333B2C01_[$i]);
            $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_[$i]["quality"] = sanitize_text_field($quality[$i]);
            $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_[$i]["url"] = sanitize_text_field($_obfuscated_0D02173C40133F24393B0D2C281902403B0630382B0201_[$i]);
        }
    }
    if (!empty($_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_) && $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_ != $old) {
        update_post_meta($post_id, "haun_download_fields", $_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_);
    } else {
        if (empty($_obfuscated_0D19091A25132D242F180A2D1F395B181E272425043922_) && $old) {
            delete_post_meta($post_id, "haun_download_fields", $old);
        }
    }
}
function haun_show_download_list($post_id)
{
    $_obfuscated_0D3C40220F2D10222B32310821390C2B1B220C27072732_ = get_post_meta($post_id, "haun_download_fields", true);
    $_obfuscated_0D2B0226253B123501380C0E34100F3415342E40233D22_ = haun_download_quality_options();
    $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_ = cs_get_option("download_fields_display");
    if (cs_get_option("enable_download_fields") && $_obfuscated_0D3C40220F2D10222B32310821390C2B1B220C27072732_) {
        echo "    <div class=\"entry-content htmlwrap clearfix table-responsive downloadbox\">\r\n      <table class=\"table table-hover download-table\">\r\n        <thead>\r\n          <tr>\r\n            <th>";
        _e("Download", "haunthemes");
        echo "</th>\r\n\r\n            ";
        if (in_array("quality", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
            echo "            \t<th>";
            _e("Quality", "haunthemes");
            echo "</th>\r\n            ";
        }
        echo "\r\n            ";
        if (in_array("size", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
            echo "            \t<th>";
            _e("File Size", "haunthemes");
            echo "</th>\r\n            ";
        }
        echo "\r\n            ";
        if (in_array("language", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
            echo "\t            <th>";
            _e("Language", "haunthemes");
            echo "</th>\r\n            ";
        }
        echo "\r\n            ";
        if (in_array("view", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
            echo "            \t<th>";
            _e("Click", "haunthemes");
            echo "</th>\r\n            ";
        }
        echo "\r\n            ";
        if (in_array("added", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
            echo "\t            <th>";
            _e("Added", "haunthemes");
            echo "</th>\r\n            ";
        }
        echo "\r\n          </tr>\r\n        </thead>\r\n        <tbody>\r\n            ";
        foreach ($_obfuscated_0D3C40220F2D10222B32310821390C2B1B220C27072732_ as $key => $val) {
            echo "                  <tr>\r\n                    <td>\r\n                        <img class=\"dl-img\" src=\"https://s2.googleusercontent.com/s2/favicons?domain=";
            echo get_root_domain($val["url"]);
            echo "\">\r\n                        <a class=\"dl-link\" data-post-id=\"";
            echo $post_id;
            echo "\" data-index=\"";
            echo $key;
            echo "\" href=\"";
            echo home_url("download/?id=" . $post_id . "&url=" . HauNCrypt::encrypt($val["url"]));
            echo "\" target=\"_blank\" rel=\"nofollow,noindex\">";
            echo $val["name"] ? esc_html($val["name"]) : "Download";
            echo "</a>\r\n                    </td>\r\n                    ";
            if (in_array("quality", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
                echo "\t                    <td class=\"quality\"><span>";
                echo esc_html($_obfuscated_0D2B0226253B123501380C0E34100F3415342E40233D22_[$val["quality"]]);
                echo "</span></td>\r\n\t\t\t\t\t";
            }
            echo "\r\n\t\t\t\t\t";
            if (in_array("size", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
                echo "                    \t<td>";
                echo esc_html($val["size"]);
                echo "</td>\r\n\t\t\t\t\t";
            }
            echo "\r\n\t\t\t\t\t";
            if (in_array("language", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
                echo "                    \t<td>";
                echo esc_html($val["languages"]);
                echo "</td>\r\n                    ";
            }
            echo "\r\n                    ";
            if (in_array("view", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
                echo "\t                    <td class=\"click-";
                echo $key;
                echo "\">";
                echo HAUNHelper::number_format_short($val["view"]);
                echo "</td>\r\n\t                ";
            }
            echo "\r\n\t                ";
            if (in_array("added", $_obfuscated_0D0439271F32050E212E153D29132C1F0A280621012A32_)) {
                echo "\t                    <td>";
                echo HAUNHelper::timeAgo($val["time"]);
                echo "</td>\r\n\t                ";
            }
            echo "\r\n                  </tr>\r\n                ";
        }
        echo "        </tbody>\r\n      </table>\r\n    </div>\r\n    <script>\r\n    \tvar \$ = jQuery.noConflict()\r\n    \t\$('.dl-link').click(function()\r\n    \t{\r\n    \t\tvar post_id = \$(this).data('post-id'),\r\n    \t\t\tindex = \$(this).data('index')\r\n\t        \$.ajax({\r\n\t            type: 'POST',\r\n\t            dataType: 'json',\r\n\t            url: haun.ajax_url,\r\n\t            data: {\r\n\t                action: 'haun_update_download_viewcount',\r\n\t                post_id: post_id,\r\n\t                index: index\r\n\t            },\r\n\t            success: function (data) {\r\n\t                console.log(data.view)\r\n\t                \$('.click-' + index).text(data.view)\r\n\t            }\r\n\t        });\r\n    \t})\r\n    </script>\r\n    ";
    }
}

?>