<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options      = array();

// -----------------------------------------
// Page Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_haun_metabox_options',
  'title'     => 'Post Info',
  'post_type' => 'post',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    // begin: a section
    array(
      'name'  => 'section_1',
      // begin: fields
      'fields' => array(
        array(
            'id'    => 'haun_original_title',
            'type'  => 'text',
            'title' => __('Original Title', 'haunthemes'),
            'attributes'    => array(
                'placeholder' => __('Original Title', 'haunthemes'),
                'style'    => 'width: 100%;',
            ),
        ),

        array(
            'id'         => 'haun_movie_status',
            'type'       => 'radio',
            'title'      => __('Status', 'haunthemes'),
            'class'      => 'horizontal',
            'options'    => array(
                'is_trailer'  => __('Trailer', 'haunthemes'),
                'ongoing'     => __('Ongoing', 'haunthemes'),
                'completed'   => __('Completed', 'haunthemes'),
                'moviecoming' => __('Movies Coming', 'haunthemes')
            ),
            'default'    => 'ongoing'
        ),

        array(
            'id'    => 'haun_thumb_url',
            'type'  => 'text',
            'title' => __('Featured image URL', 'haunthemes'),
            'attributes'    => array(
                'placeholder' => __('Post thumbnail URL', 'haunthemes'),
                'style'    => 'width: 100%;',
            ),
        ),

        array(
          'id'    => 'set_reatured_image',
          'type'  => 'switcher',
          'title' => __('Set as featured image', 'haunthemes'),
          'desc'  => __('Set as featured image and save image to server', 'haunthemes'),
          'after' => '<p class="cs-text-muted" style="display: inline-block;font-size: 12px;margin-top: 3px;margin-left: 5px;">'.__('This will be upload the image and will display on the', 'haunthemes').' <b style="color:red;font-weight:700;">'.__('Feature Image', 'haunthemes').'</b> '.__('box on right sidebar', 'haunthemes').'.</p>',
        ),

        array(
          'id'    => 'save_all_img',
          'type'  => 'switcher',
          'title' => __('Auto save images', 'haunthemes'),
          'label' => '<span class="cs-text-muted" style="display: inline-block;font-size: 12px;">'.__('Automatically find images in posts and save them to the your server and wp media library', 'haunthemes').'</span>',
          'desc'  => __('Auto save images to server', 'haunthemes'),
        ),

        array(
            'id'    => 'haun_runtime',
            'type'  => 'text',
            'title' => __('Code Movies', 'haunthemes'),
            'attributes'    => array(
                'placeholder' => __('Code Movies', 'haunthemes'),
                'style'    => 'width: 100%;',
            ),
        ),

        array(
            'id'    => 'haun_quality',
            'type'  => 'text',
            'title' => __('Quality', 'haunthemes'),
            'attributes'    => array(
                'placeholder' => 'HD, FULL HD, Vietsub, Thuyet Minh...',
                'style'    => 'width: 50%;',
            ),
        ),

      ), // end: fields
    ), // end: a section

  ),
);


// -----------------------------------------
// Post Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_videos_metabox_options',
  'title'     => 'Video Metaboxes',
  'post_type' => 'video',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'videos_metabox_options',
      'fields' => array(

        array(
          'id'         => 'video_type',
          'type'       => 'radio',
          'title'      => 'Type',
          'class'      => 'horizontal',
          'options'    => array(
            'video_url' => 'Video URL',
            'video_embed'    => 'Embed'
          ),
          'default'    => 'video_url'
        ),


        array(
          'id'        => 'haun_video_url',
          'type'      => 'fieldset',
          'title'     => 'Video URL',
          'dependency'   => array( 'video_type_video_url', '==', 'true' ),
          'fields'    => array(
                array(
                  'id'    => 'video_url',
                  'type'  => 'text',
                  'title' => 'Video URL',
                  'attributes' => array(
                    'placeholder' => 'Youtube, Vimeo, Dailymotion URL',
                  ),
                ),
            ),
        ),
        array(
          'id'        => 'haun_video_embed_code',
          'type'      => 'fieldset',
          'title'     => 'Embed / iframe',
          'dependency'   => array( 'video_type_video_embed', '==', 'true' ),
          'fields'    => array(
                array(
                      'id'    => 'video_embed',
                      'type'  => 'textarea',
                      'title' => 'Embed code',
                      'attributes' => array(
                        'placeholder' => 'Youtube, Vimeo, Dailymotion...',
                      ),
                    ),
                ),
        ),

        array(
          'id'    => 'video_thumbnail_url',
          'type'  => 'text',
          'title' => 'Thumbnail URL',
        ),

        array(
          'id'    => 'set_as_featured_image',
          'type'  => 'switcher',
          'title' => 'Set as featured image',
          'label' => 'Yes, Please do it.',
        ),

      ),
    ),

  ),
);


// -----------------------------------------
// Post Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_news_metabox_options',
  'title'     => 'News Metaboxes',
  'post_type' => 'news',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'news_metabox_options',
      'fields' => array(

        array(
          'id'    => 'save_all_img',
          'type'  => 'switcher',
          'title' => __('Auto save images', 'haunthemes'),
          'label' => '<span class="cs-text-muted" style="display: inline-block;font-size: 12px;">'.__('Automatically find images in posts and save them to the your server and wp media library', 'haunthemes').'</span>',
          'desc'  => __('Auto save images to server', 'haunthemes'),
        ),
      ),
    ),

  ),
);




CSFramework_Metabox::instance( $options );
