<?php

// ----------------------------------------
// a option section for options overview  -
// ----------------------------------------
$options[]      = array(
  'name'        => 'footer_options',
  'title'       => __('Footer', 'haunthemes'),
  'icon'        => 'fa fa-window-maximize',

  // begin: fields
  'fields'      => array(

    array(
      'type'    => 'notice',
      'class'   => 'info',
      'content' => __('This tab contains common setting options which will be applied to the whole theme.', 'haunthemes'),
    ),

    array(
      'id'      => 'footer_code',
      'type'    => 'textarea',
      'title'   => 'Footer code',
      'sanitize' => true,
      'desc'    => __('Enter the codes which you need to place in your footer. Tracking Code or any other JavaScript. (ex: Google Analytics, Clicky, Woopra, Histats, etc.).', 'haunthemes'),
    ),
    array(
      'id'    => 'enable_footer_banner_ads',
      'type'  => 'switcher',
      'title' => __('Enable footer ad', 'haunthemes'),
      'default' => false,
    ),

    array(
      'id'      => 'footer_banner_ads',
      'type'    => 'textarea',
      'title'   => __('Footer ad code', 'haunthemes'),
      'sanitize' => true,
      'desc'    => __('Use HTML, CSS, JS code', 'haunthemes'),
    ),



    array(
      'id'      => 'footer_about_text',
      'type'    => 'wysiwyg',
      'title'   => __('Footer About Text', 'haunthemes'),
      'help'    => __('You can change or remove our link from footer and use your own custom text. (Link back is always appreciated)', 'haunthemes'),
      'settings' => array(
            'textarea_rows' => 4,
            'tinymce'       => true,
            'media_buttons' => false,
          )
    ),

    array(
      'id'      => 'copyright_text',
      'type'    => 'wysiwyg',
      'title'   => __('Copyright Text', 'haunthemes'),
      'help'    => __('You can change or remove our link from footer and use your own custom text. (Link back is always appreciated)', 'haunthemes'),
      'settings' => array(
            'textarea_rows' => 4,
            'tinymce'       => true,
            'media_buttons' => false,
          )
    ),
    array(
      'id'      => 'footer_right_text',
      'type'    => 'wysiwyg',
      'title'   => __('Footer Right', 'haunthemes'),
      'help'    => __('You can change or remove our link from footer and use your own custom text. (Link back is always appreciated)', 'haunthemes'),
      'settings' => array(
            'textarea_rows' => 4,
            'tinymce'       => true,
            'media_buttons' => false
          )
    ),


  ), // end: fields
);