<?php

// ----------------------------------------
// a option section for options overview  -
// ----------------------------------------
$options[]      = array(
  'name'        => 'overwiew',
  'title'       => __('General settings', 'haunthemes'),
  'icon'        => 'fa fa-cog',

  // begin: fields
  'fields'      => array(

    array(
      'type'    => 'notice',
      'class'   => 'info',
      'content' => __('This tab contains common setting options which will be applied to the whole theme.', 'haunthemes'),
    ),
	array(
      'id'           => 'haun_post_item_title_display',
      'type'         => 'image_select',
      'title'        => __('Select List Display Style'),
      'options'      => array(
        'style-2'    => HAUN_THEME_URI.'/assets/images/style-2.png',
        'style-1'    => HAUN_THEME_URI.'/assets/images/style-1.png',
      ),
      'radio'        => true,
    ),
	array(
      'id'    => 'haun_show_title2',
      'type'  => 'switcher',
      'title' => __('Show subheadings', 'haunthemes'),
      'default' => false,
    ),
	array(
      'id'    => 'hide_required_plugins',
      'type'  => 'switcher',
      'title' => __('Hide required plugins notice', 'haunthemes'),
      'default' => false,
    ),
	
	array(
      'id'    => 'hide_admin_bar',
      'type'  => 'switcher',
      'title' => __('Hide/Show Wordpress Admin Bar', 'haunthemes'),
      'default' => false,
    ),
	array(
          'id'    => 'haun_remove_categories_prefix',
          'type'  => 'switcher',
          'title' => __('Remove the categories prefix', 'haunthemes'),
          'default' => true,
          'desc' => __('Category URLs in WordPress contain a prefix, usually <strong>/category/</strong>, this feature removes that prefix, for categories only.', 'haunthemes'),
        ),
	array(
      'id'      => 'link_telegram',
      'type'    => 'wysiwyg',
      'title'   => __('TeleGram Footer Link', 'haunthemes'),
      'help'    => __('Add Telegram to the footer of your website', 'haunthemes'),
      'settings' => array(
            'textarea_rows' => 4,
            'tinymce'       => true,
            'media_buttons' => false,
          )
    ),
    array(
      'id'    => 'disable_emojis',
      'type'  => 'switcher',
      'title' => __('Disable Emojis', 'haunthemes'),
      // 'label' => 'Yes, Please do it.',
      'default' => true,
    ),
    array(
      'id'      => 'additional_css',
      'type'    => 'textarea',
      'title'   => __('Additional CSS', 'haunthemes'),
      'sanitize' => true,
      'desc'    => __('Add your own CSS code here to customize the appearance and layout of your site.', 'haunthemes').' <br><a href="https://codex.wordpress.org/CSS" target="_blank" class="external-link">Learn more about CSS</a>',
      'attributes'    => array(
        'placeholder' => '.class_name { color: #000; padding: 10px; }'
      )
    ),
	
	


  ), // end: fields
);