<?php

// ----------------------------------------
// a option section for options overview  -
// ----------------------------------------
$options[]      = array(
  'name'        => 'header_options',
  'title'       => __('Header', 'haunthemes'),
  'icon'        => 'fa fa-window-maximize',

  // begin: fields
  'fields'      => array(

    array(
      'type'    => 'notice',
      'class'   => 'info',
      'content' => __('This tab contains common setting options which will be applied to the whole theme.', 'haunthemes'),
    ),

    array(
      'id'        => 'site_logo',
      'type'      => 'image',
      'title'     => __('Site Logo', 'haunthemes'),
      'desc'      => __('Upload your logo using the Upload Button.', 'haunthemes'),
      'add_title' => __('Add Logo', 'haunthemes'),
    ),

    array(
      'id'             => 'favicon',
      'type'           => 'upload',
      'title'          => __('Favicon', 'haunthemes'),
      'desc'           => __('Upload a 16 x 16 px image that will represent your websites favicon.', 'haunthemes'),
      'settings'       => array(
    'upload_type'  => 'image/x-icon',
        'button_title' => 'Upload',
        'frame_title'  => 'Choose a favicon',
        'insert_title' => 'Use this favicon',
      ),
    ),
    array(
      'id'             => 'apple_touch_icon',
      'type'           => 'upload',
      'title'          => __('Apple touch icon', 'haunthemes'),
      'desc'           => __('Upload a 152 x 152 px image that will represent your websites touch icon for iOS 2.0+ and Android 2.1+ devices.', 'haunthemes'),
      'settings'       => array(
    'upload_type'  => 'image/png',
        'button_title' => 'Upload',
        'frame_title'  => 'Choose a icon',
        'insert_title' => 'Use this icon',
      ),
    ),
    array(
      'id'      => 'header_code',
      'type'    => 'textarea',
      'title'   => __('Header code', 'haunthemes'),
      'sanitize' => true,
      'desc'    => __('Enter the code which you need to place before closing tag. (ex: Google Webmaster Tools verification, Bing Webmaster Center, BuySellAds Script, Alexa verification etc.)', 'haunthemes'),
    ),

    array(
      'id'    => 'enable_header_banner_ads',
      'type'  => 'switcher',
      'title' => __('Enable header ad', 'haunthemes'),
      'default' => false,
    ),

    array(
      'id'      => 'header_banner_ads',
      'type'    => 'textarea',
      'title'   => __('Header Ad code', 'haunthemes'),
      'sanitize' => true,
      'desc'    => __('Use HTML, CSS, JS code', 'haunthemes'),
    ),

  ), // end: fields
);