<?php


// ------------------------------
// Player                     -
// ------------------------------
$options[]   = array(
  'name'     => 'player_section',
  'title'    => __('Player Settings', 'haunthemes'),
  'icon'     => 'fa fa-youtube-play',
  'fields'   => array(

    array(
      'type'    => 'notice',
      'class'   => 'info',
      'content' =>  __('This tab contains common setting options which will be applied to the player.', 'haunthemes'),
    ),

	array(
	  'id'        => 'haun_jw_player_options',
	  'type'      => 'fieldset',
	  'title'     =>  __('JW Player Basic Settings', 'haunthemes'),
	  // 'dependency'   => array( 'player_select_jw_player', '==', 'true' ),
	  'fields'    => array(


	  						array(
							  'id'             => 'jw_player_version',
							  'type'           => 'select',
							  'title'          =>  __('License Version', 'haunthemes'),
							  'after'		=> '<p class="cs-text-muted">'.__('Select which edition of JW Player you own', 'haunthemes').' , <a href="http://www.jwplayer.com/pricing/" target="_blank" rel="nofollow">pricing page</a></p>',
							  'options'        => array(
								'jw_player_pro'      	 => 'Pro (free)',
								'jw_player_premium'  	 => 'Premium',
								'jw_player_ads'    		 => 'Ads',
							  ),
							),
							array(
							  'id'      => 'jw_player_library',
							  'type'    => 'upload',
							  'title'   =>  __('Player library URL', 'haunthemes'),
							  'after'   => '<p class="cs-text-muted">'.__('Add the url of the file jwplayer.js or using the Upload button.', 'haunthemes').'</p>',
								'settings'   => array(
									'upload_type'  => 'application/javascript',
									'button_title' => __('Upload JW Library', 'haunthemes'),
									'frame_title'  => 'Select .js file',
									'insert_title' => 'Use this file',
								),
							  'attributes' => array(
									'placeholder' => 'https://cdn.jwplayer.com/libraries/IDzF9Zmk.js',
							   ),
							   'default' => '/wp-content/themes/hnhaysex/player/assets/js/jwplayer-8.9.3.js'
							),

							array(
							  'id'         => 'jw_player_license_key',
							  'type'       => 'text',
							  'title'      =>  __('Jwplayer License key', 'haunthemes'),
							  'default'    => 'MBvrieqNdmVL4jV0x6LPJ0wKB/Nbz2Qq/lqm3g==',
							  'after'      => '<p class="cs-text-muted">'.__('A license key is required for the Pro, Premium and Ads edition.', 'haunthemes').'</p>',
							),
							array(
							  'id'             => 'jw_player_skin',
							  'type'           => 'select',
							  'title'          =>  __('Select Your Favorite Skin', 'haunthemes'),
							  'after'		   => '<p class="cs-text-muted">'.__('Choose or upload a skin to customize your player.', 'haunthemes').'</p>',
								  'options'        => array(
									'haun'     			 => 'HauN',
									'vapor'     			 => 'Vapor',
									'stormtrooper'   	 	 => 'Stormtrooper',
									'six'   				 => 'Six',
									'seven'   				 => 'Seven',
									'roundster'   			 => 'Roundster',
									'glow'   				 => 'Glow',
									'five'   				 => 'Five',
									'bekle'   				 => 'Bekle',
									'beelden'				 => 'Beelden',
								  ),
							),

							array(
							  'id'             => 'jw_player_logo',
							  'type'           => 'upload',
							  'title'          =>  __('Logo File', 'haunthemes'),
							  'desc'		   => '',
							  'settings'       => array(
								'button_title' => __('Upload logo', 'haunthemes'),
								'frame_title'  => 'Choose a logo',
								'insert_title' => 'Use this logo',
							  ),
							  'after' => '<p class="cs-text-muted">'.__('The URL of an external JPG, PNG or GIF image to be used as watermark (e.g. /assets/logo.png). We recommend using 24 bit PNG images with transparency', 'haunthemes').'</p>'
							),
							array(
							  'id'   		 => 'jw_player_logo_link',
							  'type'		 => 'text',
							  'title' 		 =>  __('Logo link', 'haunthemes'),
							  'attributes' => array(
								'placeholder' => 'http://haunytb.com',
							  ),
							  'after' => '<p class="cs-text-muted">'.__('The URL to visit when the watermark image is clicked. Clicking a logo will have no affect unless this is configured', 'haunthemes').'</p>'
							),
							array(
							  'id'    => 'jw_player_logo_hide',
							  'type'  => 'switcher',
							  'title' =>  __('Auto hide logo', 'haunthemes'),
							  'label' => __('When this option is set to true, the logo will automatically show and hide along with the other player controls', 'haunthemes'),
							),
							array(
							  'id'             => 'jw_player_logo_position',
							  'type'           => 'select',
							  'title'          =>  __('Logo Position', 'haunthemes'),
							  'after'		   => '<p class="cs-text-muted">'.__('This options block configures a clickable watermark that is overlayed on the video.', 'haunthemes').'</p>',
								  'options'        => array(
									'top-left'     			=> __('Top left', 'haunthemes'),
									'top-right'     		=> __('Top right', 'haunthemes'),
									'bottom-left'   	 	=> __('Bottom left', 'haunthemes'),
									'bottom-right'   		=> __('Bottom right', 'haunthemes'),
									'control-bar'   		=> __('Control bar', 'haunthemes')
								  ),
							  'after' => '<p class="cs-text-muted">'.__('This sets the corner in which to display the watermark. "control-bar" adds the logo as the leftmost icon in the right grouping of buttons in the control bar.', 'haunthemes').'</p>'
							),

							array(
							  'id'             => 'jw_player_poster_image',
							  'type'           => 'upload',
							  'title'          =>  __('Default poster image', 'haunthemes'),
							  'desc'		   => __('The poster image file loaded inside of the player', 'haunthemes'),
							  'settings'       => array(
								'button_title' => __('Upload', 'haunthemes'),
								'frame_title'  => 'Choose poster image',
								'insert_title' => 'Use this poster image',
							  ),
							),

							array(
							  'id'      => 'jw_player_default_subtitle',
							  'type'    => 'upload',
							  'title'   =>  __('Default subtitle', 'haunthemes'),
							  'after'   => '<p class="cs-text-muted">'.__('Add the url of the file subtitle.srt, .vtt or using the Upload button.', 'haunthemes').'</p>',
								'settings'   => array(
									'upload_type'  => 'text/plain',
									'button_title' => __('Upload Subtitle', 'haunthemes'),
									'frame_title'  => 'Select .srt, .vtt file',
									'insert_title' => 'Use this file',
								),
							  'attributes' => array(
								'placeholder' => home_url('subtitle/files/vietnamese.srt'),
							  ),
							),
							array(
							  'id'             => 'jw_player_subtitle_method',
							  'type'           => 'select',
							  'title'          =>  __('Select a method to read subtitles', 'haunthemes'),
							  'after'		   => '<p class="cs-text-muted">'.__('This options block configures a clickable watermark that is overlayed on the video.', 'haunthemes').'</p>',
								  'options'        => array(
									'direct_link'     		=> 'Direct link',
									'readsub_php'     		=> 'Use readsub.php'
								  ),
							  'after' => '<p class="cs-text-muted">Direct link: <i style="color: red;">https://dl.dropboxusercontent.com/s/wk5ibiqvrmgojoh/Default.srt?dl=0</i><br>Use readsub.php: <br><i style="color: #333;">'.HAUN_THEME_URI.'/player/readsub.php?file=</i><i style="color: red;">https://dl.dropboxusercontent.com/s/wk5ibiqvrmgojoh/Default.srt?dl=0</i></p>'
							),
					        array(
					          'id'      => 'jw_tracks_color',
					          'type'    => 'color_picker',
					          'title'   =>  __('Subtitle color', 'haunthemes'),
					          'after' => '<p class="cs-text-muted">'.__('Select subtitle color', 'haunthemes').'</p>'
					        ),
						    array(
						      'id'      => 'jw_tracks_font_size',
						      'type'    => 'number',
						      'title'   =>  __('Subtitle font size', 'haunthemes'),
						      'default' => '14',
							  'after' => '<i class="cs-text-muted"> px</i>'
						    ),
							array(
							  'id'    => 'jw_player_share',
							  'type'  => 'text',
							  'title' =>  __('Share Heading', 'haunthemes'),
							  'dependency'   => array( 'jw_player_sharing_block', '==', 'true' ),
							  'attributes' => array(
								'style'    => 'width: 80px;',
								'placeholder' => 'Share',
							  ),
							  'after' => '<p class="cs-text-muted">'.__('Short, instructive text to display at the top of the sharing screen. The default is Share Video. Also is displayed as a tooltip for the sharing icon.', 'haunthemes').'</p>'
							),
							array(
							  'id'    => 'jw_player_about_text',
							  'type'  => 'text',
							  'title' =>  __('About text', 'haunthemes'),
							  'attributes' => array(
								'style'    => 'width: 150px;',
								'placeholder' => 'About us',
							  ),
							  'after' => '<p class="cs-text-muted">'.__('Custom text to display in the right-click menu. Can only be set for the Premium and Ads Editions', 'haunthemes').'</p>'
							),
							array(
							  'id'    => 'jw_player_about_link',
							  'type'  => 'text',
							  'title' =>  __('About link', 'haunthemes'),
							  'attributes' => array(
								'placeholder' => 'Link to about page',
							  ),
							  'after' => '<p class="cs-text-muted">'.__('Custom URL to link to when clicking the right-click menu. Can only be set for the Premium and Ads Editions', 'haunthemes').'</p>'
							),

			  ),
              'default'   => array(
                'jw_player_version'			=> 'pro',
                'jw_player_skin'			=> 'haun',
                'jw_tracks_color'			=> '#fff',
                'jw_player_autoplay'		=> true,
                'jw_player_download'		=> true,
                'jw_player_license_key'		=> 'MBvrieqNdmVL4jV0x6LPJ0wKB/Nbz2Qq/lqm3g==',
              ),
	),

	array(
	  'id'        => 'haun_jw_player_ads',
	  'type'      => 'fieldset',
	  'title'     =>  __('Video Advertising Settings', 'haunthemes'),
	  'fields'    => array(
							array(
							  'type'    => 'notice',
							  'class'   => 'success',
							  'content' => __('You Need <b>Advertising edition (Ads)</b> of JW Player to edit Video Advertising Settings', 'haunthemes'),
							  'after'	=> '<p class="cs-notice cs-text-muted">'.__('A valid license for the Advertising edition of JW Player is required. The Free, Premium, and Enterprise editions do not support this function.', 'haunthemes').'</p>',
							),
							array(
							  'id'    => 'jw_player_show_ad',
							  'type'  => 'switcher',
							  'title' => __('Show ads', 'haunthemes'),
							  // 'label' => 'When this option is set to true, the logo will automatically show and hide along with the other player controls',
							),

						    array(
						      'id'      => 'jw_player_custom_ads_code',
						      'type'    => 'textarea',
						      'title'   => __('Ads code', 'haunthemes'),
						      'sanitize' => true,
							  'attributes' => array(
								'placeholder' => 'Example:
“advertising: {
	“tag: “https://playertest.longtailvideo.com/vast-30s-ad.xml”,
	“client: “vast”,
	“vpaidmode: “insecure”,
	“preloadAds: true
}',
							  ),
						      'after'   => '<p class="cs-text-warning"><pre><strong>ADS CONFIG EXAMPLE:</strong>
<b style="color:red;">Vast ads</b>
"advertising": {
	"tag": "https://playertest.longtailvideo.com/vast-30s-ad.xml",
	"client": "vast",
	"vpaidmode": "insecure",
	"preloadAds": true
}
<b style="color:red;">Googima ads</b>
"advertising": {
	"client": "googima",
	"schedule": "https://pubads.g.doubleclick.net/gampad/ads?sz=640x480&iu=/124319096/external/ad_rule_samples&ciu_szs=300x250&ad_rule=1&impl=s&gdfp_req=1&env=vp&output=vmap&unviewed_position_start=1&cust_params=deployment%3Ddevsite%26sample_ar%3Dpremidpost&cmsid=496&vid=short_onecue&correlator=",
	"vpaidmode": "insecure",
	"companiondiv": {
		"id": "sample-companion-div",
		"height": 250,
		"width": 300
	}
}
</pre></p><div class="cs-text-muted">'.__('Set this to vast if you are running VAST/VPAID ads, or to googima if you are running Google IMA ads.', 'haunthemes').' <br/><a href="https://developer.jwplayer.com/jw-player/docs/developer-guide/customization/configuration-reference/#advertising" target="_blank" rel="nofollow">Learn More about Advertising.</a> | <a href="https://developer.jwplayer.com/jw-player/docs/developer-guide/advertising/monetize-your-content/" target="_blank" rel="nofollow">Monetize your content</a> | <a href="https://developer.jwplayer.com/tools/ad-tester/" target="_blank" rel="nofollow">JW Player Ad Tester</a></div>',
						      'desc'    => __('Specific advertising options.', 'haunthemes'),
						    ),
			  ),

	),

  )
);