<?php

function haun_add_buttom_episode_manager() {
    add_meta_box('haun_add_buttom_episode_manager', __('Manage Episode', 'haunthemes'), 'haun_button_eps_manager','post', 'side', 'high');
}
add_action('add_meta_boxes', 'haun_add_buttom_episode_manager');
function haun_button_eps_manager() {
    echo '<style>
            select#haun_custom_sidebar {
                width: 100%;
            }
            #haun_add_buttom_episode_manager .inside {
                display: grid;
            }
            .btn-add-ep {
                background-image: linear-gradient(to right, #4c8c11 0%, #9dd249 100%, #62882b 100%);
                padding: 10px;
                text-align: center;
                color: #fff;
                font-size: 16px;
                font-weight: 700;
                text-decoration: none;
                border-radius: 3px;
            }
            .btn-add-ep:hover {
                color: #fff
            }
        </style>';
    $post_id = isset($_GET['post']) ? $_GET['post'] : '';
    if($post_id)
       echo '<a class="btn-add-ep" href="'.admin_url('admin.php?page=haun-episode-manager&act=edit_ep&post_id='.$post_id.'&server=0&episode=1&paged=1&cat=').'">'._e('Manage Episode','haunthemes').'</a>';
    else
        echo '<strong style="color:red">'.__('Please publish post before you can edit episodes','haunthemes').'</strong>';
}

// Widget lists
include_once HAUN_INC_WIDGET.'/HNWidget/haun-latest-post.php';
include_once HAUN_INC_WIDGET.'/HNWidget/haun-latest-update.php';
include_once HAUN_INC_WIDGET.'/HNWidget/haun-related-video-widget.php';

/*-----------------------------------------------------------------------------------*/
/*	Enable Widgetized sidebar and Footer
/*-----------------------------------------------------------------------------------*/
if ( function_exists( 'register_sidebar' ) ) {
    function haun_register_sidebars() {
        $register_sidebar = cs_get_option('haun_register_sidebars');
		
		register_sidebar(array(
            'id'            => 'home-widget',
            'name'          => 'Homepage Widget',
            'description'   => 'Khu vực widget hiển thị danh sách phim, có thể chèn widget bất kì (Đề xuất: "HauN Movies Widget", "HauN TV-Series Widget", "HauN Vertical Widget", "HauN Category Widget" và các widget HTML tùy chỉnh)',
            'before_widget' => '',
            'after_widget'  => '',
            'before_title'  => '',
            'after_title'   => '',
        ));
		
        register_sidebar(array(
            'id'            => 'sidebar',
            'name'          => 'Sidebar Widget',
            'description'   => 'Khu vực widget hiển thị danh sách phim ở Sidebar (Vui lòng chèn các widget "HauN TOP TV-Series", "HauN TOP Movies", "HauN Trailer Widget", "HauN Posts Viewed Recently", "HauN Polpular Movies" và các widget HTML tùy chỉnh)',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>',
        ));

        register_sidebar(array(
            'id'            => 'bs-slider',
            'name'          => 'HauN One Slide (Slider one by one)',
            'description'   => 'Khu vực widget hiển thị danh sách phim bằng thanh trượt (Widget HauN One Slide - Slider one by one), có thể chèn thêm các widget khác',
            'before_widget' => '',
            'after_widget'  => '',
            'before_title'  => '',
            'after_title'   => '',
        ));

        register_sidebar(array(
            'id'            => 'carousel-widget',
            'name'          => 'HauN Carousel Slider',
            'description'   => 'Khu vực widget hiển thị danh sách phim bằng thanh trượt (Widget HauN Carousel Slider), có thể chèn thêm các widget khác',
            'before_widget' => '',
            'after_widget'  => '',
            'before_title'  => '',
            'after_title'   => '',
        ));


        register_sidebar(array(
            'id'            => 'related-video',
            'name'          => 'Related Movies',
            'description'   => 'Khu vực widget hiển thị phim cùng thể loại, có thể chèn thêm các widget khác',
            'before_widget' => '',
            'after_widget'  => '',
            'before_title'  => '',
            'after_title'   => '',
        ));

        register_sidebar(array(
            'id'            => 'haun-ad-above-player',
            'name'          => 'Advertisements above the player',
            'description'   => 'Khu vực widget hiển thị quảng cáo ở phía trên trình phát video',
            'before_widget' => '<div class="text-center">',
            'after_widget'  => '</div>',
            'before_title'  => '',
            'after_title'   => '',
        ));

        register_sidebar(array(
            'id'            => 'haun-ad-below-player',
            'name'          => 'Advertisements below the player',
            'description'   => 'Khu vực widget hiển thị quảng cáo ở phía dưới trình phát video',
            'before_widget' => '<div class="text-center">',
            'after_widget'  => '</div>',
            'before_title'  => '',
            'after_title'   => '',
        ));

        register_sidebar(array(
            'id'            => 'haun-ad-above-category',
            'name'          => 'Advertise above the category, page, search, tag',
            'description'   => 'Khu vực widget hiển thị quảng cáo ở phía trên trang thể loại, trang tùy chỉnh, trang tìm kiếm, trang từ khóa',
            'before_widget' => '<div class="text-center">',
            'after_widget'  => '</div>',
            'before_title'  => '',
            'after_title'   => '',
        ));

        register_sidebar(array(
            'id'            => 'haun-ad-below-category',
            'name'          => 'Advertise below the category, page, search, tag',
            'description'   => 'Khu vực widget hiển thị quảng cáo ở phía dưới trang thể loại, trang tùy chỉnh, trang tìm kiếm, trang từ khóa',
            'before_widget' => '<div class="text-center">',
            'after_widget'  => '</div>',
            'before_title'  => '',
            'after_title'   => '',
        ));

        register_sidebar( array(
            'name'          => 'Footer',
            'id'            => 'footer',
            'description'   => 'Khu vực widget hiển thị ở footer, có thể chèn các widget HTML tùy chỉnh (Liên kết, banner...), Widget chuyên mục, Widget Thanh điều hướng...',
            'before_widget' => '<div id="%1$s" class="widget %2$s col-xs-12 col-sm-6 col-md-4">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>',
        ) );

        // Custom sidebars
        if ( !empty( $register_sidebar ) && is_array( $register_sidebar )) {
            foreach( $register_sidebar as $sidebar ) {
                if ( !empty( $sidebar['haun_custom_sidebar_id'] ) && !empty( $sidebar['haun_custom_sidebar_id'] ) && $sidebar['haun_custom_sidebar_id'] != 'sidebar-' ) {
                    register_sidebar( array( 'name' => ''.$sidebar['haun_custom_sidebar_name'].'', 'id' => ''.sanitize_title( strtolower( $sidebar['haun_custom_sidebar_id'] )).'', 'before_widget' => '<div id="%1$s" class="widget %2$s">', 'after_widget' => '</div>', 'before_title' => '<h3>', 'after_title' => '</h3>' ));
                }
            }
        }


    }

    add_action( 'widgets_init', 'haun_register_sidebars' );
}

function haun_custom_sidebar() {
    $haun_sidebar = cs_get_option('haun_sidebar_section');

	// Default sidebar
	$sidebar = 'sidebar';

	if ( is_home() && !empty( $haun_sidebar['sidebar_homepage'] )) $sidebar = $haun_sidebar['sidebar_homepage'];
    if ( is_single() && !empty( $haun_sidebar['sidebar_single_post'] )) $sidebar = $haun_sidebar['sidebar_single_post'];

    if ( is_page() && !empty( $haun_sidebar['sidebar_page'] )) $sidebar = $haun_sidebar['sidebar_page'];

    // Archives
	if ( is_archive() && !empty( $haun_sidebar['sidebar_archive'] )) $sidebar = $haun_sidebar['sidebar_archive'];
	if ( is_category() && !empty( $haun_sidebar['sidebar_category'] )) $sidebar = $haun_sidebar['sidebar_category'];
    if ( is_tag() && !empty( $haun_sidebar['sidebar_tag'] )) $sidebar = $haun_sidebar['sidebar_tag'];
    if ( is_date() && !empty( $haun_sidebar['sidebar_date'] )) $sidebar = $haun_sidebar['sidebar_date'];

    // Other
    if ( is_search() && !empty( $haun_sidebar['sidebar_search'] )) $sidebar = $haun_sidebar['sidebar_search'];
	if ( is_404() && !empty( $haun_sidebar['sidebar_404'] )) $sidebar = $haun_sidebar['sidebar_404'];


	// Page/post specific custom sidebar
	if ( is_page() || is_single() ) {
		wp_reset_postdata();
		global $post;
        $custom = get_post_meta( $post->ID, '_haun_custom_sidebar', true );
		if ( !empty( $custom )) $sidebar = $custom;
	}

	return $sidebar;
}


/*-----------------------------------------------------------------------------------*/
/*  Sidebar Selection meta box
/*-----------------------------------------------------------------------------------*/
function haun_add_sidebar_metabox() {
    $screens = array('post', 'page', 'news', 'video');
    foreach ($screens as $screen) {
        add_meta_box(
            'haun_sidebar_metabox',                  // id
            __('Sidebar', 'haunthemes'),    // title
            'haun_inner_sidebar_metabox',            // callback
            $screen,                                // post_type
            'side',                                 // context (normal, advanced, side)
            'high'                               // priority (high, core, default, low)
                                                    // callback args ($post passed by default)
        );
    }
}
add_action('add_meta_boxes', 'haun_add_sidebar_metabox');


/**
 * Print the box content.
 *
 * @param WP_Post $post The object for the current post/page.
 */
function haun_inner_sidebar_metabox($post) {
    global $wp_registered_sidebars;

    // Add an nonce field so we can check for it later.
    wp_nonce_field('haun_inner_sidebar_metabox', 'haun_inner_sidebar_metabox_nonce');

    /*
    * Use get_post_meta() to retrieve an existing value
    * from the database and use the value for the form.
    */
    $custom_sidebar = get_post_meta( $post->ID, '_haun_custom_sidebar', true );
    // $sidebar_location = get_post_meta( $post->ID, '_haun_sidebar_location', true );

    // Select custom sidebar from dropdown
    echo '<select name="haun_custom_sidebar" id="haun_custom_sidebar" style="margin-bottom: 10px;">';
    echo '<option value="" '.selected('', $custom_sidebar).'>-- '.__('Default', 'haunthemes').' --</option>';

    // Exclude built-in sidebars
    $hidden_sidebars = array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar');

    foreach ($wp_registered_sidebars as $sidebar) {
        if (!in_array($sidebar['id'], $hidden_sidebars)) {
            echo '<option value="'.esc_attr($sidebar['id']).'" '.selected($sidebar['id'], $custom_sidebar, false).'>'.$sidebar['name'].'</option>';
        }
    }
    echo '<option value="haun_nosidebar" '.selected('haun_nosidebar', $custom_sidebar).'>-- '.__('No sidebar --', 'haunthemes').'</option>';
    echo '</select><br />';

    // Select single layout (left/right sidebar)
    // echo '<div class="haun_sidebar_location_fields">';
    // echo '<label for="haun_sidebar_location_default" style="display: inline-block; margin-right: 20px;"><input type="radio" name="haun_sidebar_location" id="haun_sidebar_location_default" value=""'.checked('', $sidebar_location, false).'>'.__('Default side', 'haunthemes').'</label>';
    // echo '<label for="haun_sidebar_location_left" style="display: inline-block; margin-right: 20px;"><input type="radio" name="haun_sidebar_location" id="haun_sidebar_location_left" value="left"'.checked('left', $sidebar_location, false).'>'.__('Left', 'haunthemes').'</label>';
    // echo '<label for="haun_sidebar_location_right" style="display: inline-block; margin-right: 20px;"><input type="radio" name="haun_sidebar_location" id="haun_sidebar_location_right" value="right"'.checked('right', $sidebar_location, false).'>'.__('Right', 'haunthemes').'</label>';
    // echo '</div>';

    ?>
<!--     <script>
        jQuery(document).ready(function($) {
            function haun_toggle_sidebar_location_fields() {
                $('.haun_sidebar_location_fields').toggle(($('#haun_custom_sidebar').val() != 'haun_nosidebar'));
            }
            haun_toggle_sidebar_location_fields();
                $('#haun_custom_sidebar').change(function() {
                haun_toggle_sidebar_location_fields();
            });
        });
    </script> -->
    <?php
    //debug
    //global $wp_meta_boxes;
}

/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function haun_save_custom_sidebar( $post_id ) {

    /*
    * We need to verify this came from our screen and with proper authorization,
    * because save_post can be triggered at other times.
    */

    // Check if our nonce is set.
    if ( ! isset( $_POST['haun_inner_sidebar_metabox_nonce'] ) )
    return $post_id;

    $nonce = $_POST['haun_inner_sidebar_metabox_nonce'];

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( $nonce, 'haun_inner_sidebar_metabox' ) )
      return $post_id;

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
      return $post_id;

    // Check the user's permissions.
    if ( 'page' == $_POST['post_type'] ) {

    if ( ! current_user_can( 'edit_page', $post_id ) )
        return $post_id;

    } else {

    if ( ! current_user_can( 'edit_post', $post_id ) )
        return $post_id;
    }

    /* OK, its safe for us to save the data now. */

    // Sanitize user input.
    $sidebar_name = sanitize_text_field( $_POST['haun_custom_sidebar'] );
    // $sidebar_location = sanitize_text_field( $_POST['haun_sidebar_location'] );

    // Update the meta field in the database.
    update_post_meta( $post_id, '_haun_custom_sidebar', $sidebar_name );
    // update_post_meta( $post_id, '_haun_sidebar_location', $sidebar_location );

}
add_action( 'save_post', 'haun_save_custom_sidebar' );