<?php

class haun_related_video_Widget extends WP_Widget
{
	public function __construct() {
		parent::__construct(
			'haun_related_movies',
			__( 'Halim Related Movie', 'haunthemes' ),
			array(
				'classname'   => 'haun_related_movies',
				'description' => __( 'Display related movies', 'haunthemes' )
			)
		);
	}

	function widget($args, $instance)
	{
		global $post;
		extract($args);
		$title = $instance['title'];
		$postnum = $instance['postnum'];
		$related_by = $instance['related_by'];
		echo $before_widget;
		$meta = get_post_meta($post->ID, '_haun_metabox_options', true);
		$post_format = haun_get_post_format_type($meta['haun_movie_formality']);
		ob_start();
		?>
		<div id="video-list">
				<h2 class="breadcrumb"><?php echo $title; ?></h2>
				<?php
					$categories = get_the_category($post->ID);
					if ($categories){
						$category_ids = array();
						foreach ($categories as $individual_category) {
							$category_ids[] = $individual_category->term_id;
						}
					}

					$tags = wp_get_post_terms($post->ID, 'post_tag', ['fields' => 'ids'] );

					$args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'post__not_in'        => array($post->ID),
						'showposts'           => $postnum,
						'orderby'             => 'rand',
						'ignore_sticky_posts' => 1
					);
					if($related_by == 'tag') {
						if($tags) {
							// $args['tag__in'] = $tags;
						    $args['tax_query'] = [
						        [
						            'taxonomy' => 'post_tag',
						            'terms'    => $tags
						        ]
						    ];
						} else {
							$args['category__in'] = $category_ids;
						}
					} else {
						$args['category__in'] = $category_ids;
					}


	                $args['tax_query'] = array(array(
	                    'taxonomy' => 'post_format',
	                    'field' => 'slug',
	                    'terms' => array('post-format-'.$post_format),
	                    'operator' => 'IN'
	                ));

					$wp_query = new WP_Query($args);

					if($related_by == 'tag') {
						if($wp_query->post_count == 0) {
							$args1 = array(
								'post_type' => 'post',
								'post_status' => 'publish',
								'post__not_in'        => array($post->ID),
								'category__in' 			=> $category_ids,
								'showposts'           => $postnum,
								'orderby'             => 'rand',
								'ignore_sticky_posts' => 1,
							);
						    // $args['tax_query'] = [
						    //     [
						    //         'taxonomy' => 'category',
						    //         'field'    => 'id',
						    //         'terms'    => $category_ids,
						    //         'operator' => 'IN'
						    //     ]
						    // ];
							$wp_query = new WP_Query($args1);
						}
					}

					if ($wp_query->have_posts()) {
						echo '';
						while ($wp_query->have_posts())
						{
							$wp_query->the_post();
								display_post_items();
						}
						wp_reset_postdata();
					}
				?>
			</div>
		<?php

		echo $after_widget;
		$html = ob_get_contents();
		ob_end_clean();
		echo $html;
	}
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['postnum'] = $new_instance['postnum'];
		$instance['related_by'] = $new_instance['related_by'];

		return $instance;
	}

	function form($instance)
	{
		$instance = wp_parse_args( (array) $instance, array(
			'title' 	=> 'Similar movies',
			'postnum' 	=> 8,
			'type'		=> 'slider',
			'related_by' => 'category'
		) );
		extract($instance);

		 ?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'haunthemes') ?></label>
				<br>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>" />
			</p>


			<p>
			<label><?php _e('Related by', 'haunthemes') ?></label>
			<br>
			<?php
			  $fx = array( 'tag' => __('Tag', 'haunthemes'), 'category' => __('Category', 'haunthemes'));
				foreach ($fx as $x => $n ) { ?>
				<label for="<?php echo $this->get_field_id("related_by"); ?>_<?php echo $x ?>">
					<input id="<?php echo $this->get_field_id("related_by"); ?>_<?php echo $x ?>" class="<?php echo $x ?>" name="<?php echo $this->get_field_name("related_by"); ?>" type="radio" value="<?php echo $x ?>" <?php if (isset($related_by)) { checked( $x, $related_by, true ); } ?> /> <?php echo $n ?>
				</label>
			<?php } ?>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('postnum'); ?>"><?php _e('Number of post to show', 'haunthemes') ?></label>
				<input type="number" class="widefat" style="width: 60px;" id="<?php echo $this->get_field_id('postnum'); ?>" name="<?php echo $this->get_field_name('postnum'); ?>" value="<?php echo $instance['postnum']; ?>" />
			</p>
		<?php
	}
}

add_action('widgets_init', 'haun_related_video_widgets');
function haun_related_video_widgets()
{
	register_widget('haun_related_video_Widget');
}
?>