<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#234556">
    <meta name="msapplication-navbutton-color" content="#234556">
	<meta name="_token" id="token" value="">
	<meta name="_socket" id="socket" value="6001">
    <meta name="apple-mobile-web-app-status-bar-style" content="#234556">
	<?php if(is_page() || is_front_page()): ?>
	<meta name="description" content="<?php echo get_bloginfo('description') ?? 'Xem Phim Sex Online'; ?>">
	<?php endif; ?>
    <?php if (cs_get_option('favicon')): ?>
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo esc_url(cs_get_option('apple_touch_icon')); ?>" />
    <link rel="shortcut icon" href="<?php echo esc_url(cs_get_option('favicon')); ?>" type="image/x-icon" />
    <?php else: ?>
    <link rel="shortcut icon" href="<?php echo HAUN_THEME_URI ?>/assets/images/favicon.ico" type="image/x-icon" />
	<?php endif; ?>
	<?php
        wp_head();
        if (cs_get_option('header_code')) echo cs_get_option('header_code')."\n";
        $logo = '';
        if(cs_get_option('site_logo'))
            $logo = wp_get_attachment_image_src(cs_get_option('site_logo'), 'full')[0];
    if($logo) :
        $logohn =  esc_attr($logo);
    else:
       $logohn = HAUN_THEME_URI .'/assets/images/logo.png';
    endif; 
	 ?>
	
</head>
<body>
<div id="wrapper">
	<div id="header">
		<header>
			<h1 class="hidden"><?php get_bloginfo('name'); ?></h1>
			<div id="logo">
				<div itemscope="" itemtype="https://schema.org/Organization" class="logoWrapper">
					<a itemprop="url" href="/">
						<img itemprop="logo" src="<?php echo $logohn; ?>" width="200" height="30px" title="<?php get_bloginfo('name'); ?>" alt="<?php get_bloginfo('description'); ?>">
					</a>
				</div>
			</div>
		</header>
		<div class="clear"></div>
		<?php
			wp_nav_menu( array(
				'depth'             => 2,
				'theme_location'    => 'header_menu',
				'container_id'   	=> 'primary-nav',
				'menu_class'        => 'menu',
				'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
				'walker'            => new wp_bootstrap_navwalker())
			);
		?>
		<div id="search-box">
			<form class="search" action="/" method="get">
				<span class="icon-search"></span>
				<input type="text" name="s" placeholder="<?php echo __('Genre, actors, codes,...', 'haunthemes'); ?>" onfocus="if (this.value == '<?php echo __('Genre, actors, codes,...', 'haunthemes'); ?>') {this.value = '';}" onblur="if (this.value == '') {this.placeholder = '<?php echo __('Genre, actors, codes,...', 'haunthemes'); ?>';}" class="searchTxt">
				<input type="submit" value="<?php echo __('Search', 'haunthemes'); ?>" class="searchBtn">
			</form>
		</div>
	</div>
	<div class="clear"></div>
<div id="container">