<?php
if(!function_exists('haunBuildPlayer')) {
    function haunBuildPlayer($post_id, $sources = null, $tracks = array(), $link = '') {
        ob_start();
        $cache_time         = cs_get_option('player_cache_time');
        $player_ad_cfg      = cs_get_option('haun_jw_player_ads');
        $player_cfg         = cs_get_option('haun_jw_player_options');
        $detect_adblock     = cs_get_option('detect_adblock');
        $adblock_msg        = cs_get_option('adblock_msg') ? cs_get_option('adblock_msg') : '<p style="padding-top:15px;"><h2>Sorry!</h2> Users please remove ad blocker!</p>';
        $floating_player    = cs_get_option('floating_player');
        $meta               = get_post_meta($post_id, '_haun_metabox_options', true );
        $player_logo        = isset($player_cfg['jw_player_logo']) ? $player_cfg['jw_player_logo'] : '';
        $player_logo_hide   = isset($player_cfg['jw_player_logo_hide']) && $player_cfg['jw_player_logo_hide'] == 1 ? "true" : "false";
        $logo_position      = isset($player_cfg['jw_player_logo_position']) ? $player_cfg['jw_player_logo_position'] : '';
        $player_logo_link   = isset($player_cfg['jw_player_logo_link']) ? $player_cfg['jw_player_logo_link'] : 'https://haunytb.com';
        $captions_color     = isset($player_cfg['jw_tracks_color']) && $player_cfg['jw_tracks_color'] ? $player_cfg['jw_tracks_color'] : '#eeee22';
        $captions_font_size = isset($player_cfg['jw_tracks_font_size']) && $player_cfg['jw_tracks_font_size'] ? $player_cfg['jw_tracks_font_size'] : 12;
        $jwplayer_key       = isset($player_cfg['jw_player_license_key']) && $player_cfg['jw_player_license_key'] ?
        $player_cfg['jw_player_license_key'] : 'MBvrieqNdmVL4jV0x6LPJ0wKB/Nbz2Qq/lqm3g==';
        $player_sharing     = isset($player_cfg['jw_player_sharing_block']) ? $player_cfg['jw_player_sharing_block'] : '';
        $autoplay           = isset($player_cfg['jw_player_autoplay']) && $player_cfg['jw_player_autoplay'] == true ? 'true' : 'false';
        $autopause           = isset($player_cfg['jw_player_autopause']) && $player_cfg['jw_player_autopause'] == true ? 'true' : 'false';
        $poster             = isset($meta['haun_poster_url']) && $meta['haun_poster_url'] ? $meta['haun_poster_url'] : '';
        $jw_adcode          = isset($player_ad_cfg['jw_player_show_ad']) && $player_ad_cfg['jw_player_custom_ads_code'] ? $player_ad_cfg['jw_player_custom_ads_code'] : '';
        $sources            = $sources == '[]' || $sources == '' || $sources == 'null' || !json_decode($sources)[0]->file ? '[{ file: "//content.jwplatform.com/videos/not-a-real-video-file.mp4", label: "720p", type: "video/mp4"}]' : $sources;
        ?>
            <script>
                var resumeId = encodeURI('<?php echo md5($sources); ?>'),
                    playerInstance = jwplayer('video-player');
                if(typeof playerInstance != 'undefined'){
                    playerInstance.setup({
                        key: "<?php echo $jwplayer_key; ?>",
                        primary: "html5",
                        playlist: [{
                            title: "<?php echo get_the_title($post_id); ?>",
                            image: "<?php echo $poster; ?>",
                            sources: <?php echo $sources; ?>,
                            tracks: <?php echo $tracks; ?>,
                            captions: {
                                color: "<?php echo $captions_color; ?>",
                                fontSize: <?php echo $captions_font_size; ?>,
                                backgroundOpacity: 0,
                                edgeStyle: "raised"
                            }
                        }],
                        <?php if($player_logo) : ?>
                        logo: {
                            file: "<?php echo $player_logo; ?>",
                            link: "<?php echo $player_logo_link; ?>",
                            hide: "<?php echo $player_logo_hide; ?>",
                            target: "_blank",
                            position: "<?php echo $logo_position; ?>",
                        },
                        <?php endif; ?>
                        <?php if($autopause) : ?>
                        autoPause: {
                            viewability: true,
                            pauseAds: true
                        },
                        <?php endif; ?>
                        base: ".",
                        width: "100%",
                        height: "100%",
                        hlshtml: true,
                        autostart: <?php echo $autoplay; ?>,
                        fullscreen: true,
                        playbackRateControls: true,
                        displayPlaybackLabel: true,
                        aspectratio: "16:9",
                        <?php if($player_sharing == true) : ?>
                        sharing: {
                            sites: ["reddit","facebook","twitter","googleplus","email","linkedin"]
                        },
                        <?php endif; ?>
                        <?php echo $jw_adcode; ?>
                    });
                    //haunResumeVideo(resumeId, playerInstance);
					var d4 = '<svg xmlns="http://www.w3.org/2000/svg" class="jw-svg-icon jw-svg-icon-rewind2" viewBox="0 0 240 240" focusable="false"><path d="m 25.993957,57.778 v 125.3 c 0.03604,2.63589 2.164107,4.76396 4.8,4.8 h 62.7 v -19.3 h -48.2 v -96.4 H 160.99396 v 19.3 c 0,5.3 3.6,7.2 8,4.3 l 41.8,-27.9 c 2.93574,-1.480087 4.13843,-5.04363 2.7,-8 -0.57502,-1.174985 -1.52502,-2.124979 -2.7,-2.7 l -41.8,-27.9 c -4.4,-2.9 -8,-1 -8,4.3 v 19.3 H 30.893957 c -2.689569,0.03972 -4.860275,2.210431 -4.9,4.9 z m 163.422413,73.04577 c -3.72072,-6.30626 -10.38421,-10.29683 -17.7,-10.6 -7.31579,0.30317 -13.97928,4.29374 -17.7,10.6 -8.60009,14.23525 -8.60009,32.06475 0,46.3 3.72072,6.30626 10.38421,10.29683 17.7,10.6 7.31579,-0.30317 13.97928,-4.29374 17.7,-10.6 8.60009,-14.23525 8.60009,-32.06475 0,-46.3 z m -17.7,47.2 c -7.8,0 -14.4,-11 -14.4,-24.1 0,-13.1 6.6,-24.1 14.4,-24.1 7.8,0 14.4,11 14.4,24.1 0,13.1 -6.5,24.1 -14.4,24.1 z m -47.77056,9.72863 v -51 l -4.8,4.8 -6.8,-6.8 13,-12.99999 c 3.02543,-3.03598 8.21053,-0.88605 8.2,3.4 v 62.69999 z"></path></svg>'
					jwplayer().addButton(d4, '', function() {
						var du = jwplayer().getDuration();
						var po = jwplayer().getPosition();
						if (po + 10 < du)
							jwplayer().seek(po + 10)
					}, 'rewind2', 'jw-icon-rewind2')
					var d3 = '<svg xmlns="http://www.w3.org/2000/svg" class="jw-svg-icon jw-svg-icon-rewind" viewBox="0 0 240 240" focusable="false"><path d="M113.2,131.078a21.589,21.589,0,0,0-17.7-10.6,21.589,21.589,0,0,0-17.7,10.6,44.769,44.769,0,0,0,0,46.3,21.589,21.589,0,0,0,17.7,10.6,21.589,21.589,0,0,0,17.7-10.6,44.769,44.769,0,0,0,0-46.3Zm-17.7,47.2c-7.8,0-14.4-11-14.4-24.1s6.6-24.1,14.4-24.1,14.4,11,14.4,24.1S103.4,178.278,95.5,178.278Zm-43.4,9.7v-51l-4.8,4.8-6.8-6.8,13-13a4.8,4.8,0,0,1,8.2,3.4v62.7l-9.6-.1Zm162-130.2v125.3a4.867,4.867,0,0,1-4.8,4.8H146.6v-19.3h48.2v-96.4H79.1v19.3c0,5.3-3.6,7.2-8,4.3l-41.8-27.9a6.013,6.013,0,0,1-2.7-8,5.887,5.887,0,0,1,2.7-2.7l41.8-27.9c4.4-2.9,8-1,8,4.3v19.3H209.2A4.974,4.974,0,0,1,214.1,57.778Z"></path></svg>'
					jwplayer().addButton(d3, '', function() {
						var du = jwplayer().getDuration();
						var po = jwplayer().getPosition();
						if (po - 10 > 0)
							jwplayer().seek(po - 10)
					}, 'rewind3', 'jw-icon-rewind3')
					var FF = function() {
						var c = $('.bt_active').next();
						if (c.length && !c.is('.zoom'))
							c.click()
						else
							$('#video .video-player').append("<p style='background:#2b2b2b; color: #fff; text-align:center; margin-top: 5px; padding: 5px;'>File video này bị lỗi hoặc đang được xử lý." + "<br /><font color='#ea4335'>Vui lòng quay lại sau.</font></p>");
					};
					jwplayer('video-player').on('error', FF);
					jwplayer('video-player').on('setupError', FF)
                    <?php if($detect_adblock) : ?>
                        playerInstance.on('adBlock', function(){
                            playerInstance.pause();
                            jQuery("#haun-player-loader").show().html('<?php echo HAUNHelper::compress_htmlcode($adblock_msg); ?>');
                        });
                    <?php endif; ?>
                }
            </script>
        <?php
        do_action('haun_player_instance', (object)['post_id' => $post_id, 'link' => $link]);
        $html = ob_get_clean();
        echo $html;
    }
}

if(!function_exists('haunBuildPlayerShotcode')) {
    function haunBuildPlayerShotcode($attr) {
        $args = shortcode_atts(array(
                'link' => '#',
                'post_id' => get_the_ID(),
                'sources' => '',
                'tracks' => '[]'

            ), $attr);

        haunBuildPlayer($args['post_id'], base64_decode($args['sources']), $args['tracks'], $args['link']);
    }
    add_shortcode( 'haunPlayer', 'haunBuildPlayerShotcode' );
}
