<?php get_header(); ?>
<h2 id="page-title" class="breadcrumb">Từ Khoá: <?php echo get_search_query(); ?></h2>
<div id="video-list">
	<?php
	global $wpdb;
	$search_query = get_search_query();
	$sql = $wpdb->prepare("
		SELECT DISTINCT $wpdb->posts.*
		FROM $wpdb->posts
		LEFT JOIN $wpdb->postmeta ON ($wpdb->posts.ID = $wpdb->postmeta.post_id)
		WHERE (
			$wpdb->posts.post_title LIKE '%%%s%%'
			OR $wpdb->postmeta.meta_key = '_haun_metabox_options'
			AND $wpdb->postmeta.meta_value LIKE '%%%s%%'
		)
		AND $wpdb->posts.post_status = 'publish'
		AND $wpdb->posts.post_type = 'post'
	", $search_query, $search_query);

	$page = max(1, get_query_var('paged')); 
	$posts_per_page = 30; 
	$offset = ($page - 1) * $posts_per_page;

	$sql_with_pagination = $sql . " LIMIT $offset, $posts_per_page";

	$search_results = $wpdb->get_results($sql_with_pagination);

	if ($search_results) :
		foreach ($search_results as $post) :
			setup_postdata($post);
			display_post_items();
		endforeach;
		wp_reset_postdata();
	else :
		
	endif;
	?>
	<div class="clear"></div>
	<?php haun_paginationa(); ?>
</div>
<?php get_footer(); ?>
