<?php
    get_header();
	$haun_action    = get_query_var('haun_action');
	$episode         = get_query_var('haun_episode');
	$server          = get_query_var('haun_server');
	$meta            = get_post_meta($post->ID, '_haun_metabox_options', true );
	haun_set_post_view_count($post->ID);
	$is_adult 		 = isset($meta['is_adult']) ? $meta['is_adult'] : '';
	$post_slug       = basename(get_permalink($post->ID));
	$type_slug       = cs_get_option('haun_url_type');
	$watch_slug      = cs_get_option('haun_watch_url');
	$episode_slug    = cs_get_option('haun_episode_url');
	$server_slug     = cs_get_option('haun_server_url');
    $link = home_url('/'.$watch_slug.'-'.$post_slug);
	$episode_display = cs_get_option('haun_episode_display');
	$first_episode = '';
    $post_meta = get_post_meta($post->ID, '_haunmovies', true);
    $data = json_decode(stripslashes($post_meta), true);
    if($data) {
    	$first_episode = key($data[0]['haunmovies_server_data']);
    }
	$ep_slug = get_query_var('episode_slug');
	$config = [
			'act'               => $haun_action,
			'post_url'          => $link,
			'ajax_url'          => HAUN_THEME_URI.'/haunytb/HNAjax.php',
			'player_url'        => HAUN_THEME_URI.'/haunytb/HNPlayer.php',
			'loading_img'       => HAUN_THEME_URI .'/assets/images/ajax-loader.gif',
			'eps_slug'          => $episode_slug,
			'server_slug'       => $server_slug,
			'type_slug'         => $type_slug,
			'post_title'        => $post->post_title,
			'post_id'           => $post->ID,
			'episode_slug'      => $ep_slug ? $ep_slug : str_replace('_', '-', $first_episode),
			'server'            => $server ? $server : cs_get_option('episode_server_default'),
			'custom_var'		=> isset($_GET['custom_var']) ? sanitize_text_field($_GET['custom_var']) : '',
			'player_error_detect' => cs_get_option('player_error_detect') ? cs_get_option('player_error_detect') : 'display_modal',
			'paging_episode'    =>  isEpisodePagenav($meta) ? 'true' : 'false',
			'episode_display'   =>  $episode_display != '' ? $episode_display : 'none',
			'episode_nav_num'   => (int)cs_get_option('episode_pagination'),
			'auto_reset_cache'  => cs_get_option('auto_reset_cache'),
			'resume_playback'   => cs_get_option('resume_playback'),
	];

    if(isset($meta['haun_thumb_url']) && $meta['haun_thumb_url']) {
    	if(strpos($meta['haun_thumb_url'], home_url()) !== false) {
	        $meta['haun_thumb_url'] = haun_make_url_relative($meta['haun_thumb_url']);
	        $meta['haun_thumb_url'] = $meta['haun_thumb_url'];
	        update_post_meta($post->ID, '_haun_metabox_options', $meta);
    	}
    }

    $single_tpl = cs_get_option('single_template');
	if($single_tpl == NULL || $haun_action) {
		do_action('haun_player_fullwidth', $meta);
	}
	$issues = preg_split('/\r\n|[\r\n]/', get_option('haun_report_issues'));
		foreach ($issues as $key => $val) {
			$metarp[] = $val;
	}
?>
<script>
    var ip = "<?php echo $_SERVER['REMOTE_ADDR']; ?>";
    var vid = '<?php echo $post->ID; ?>';
</script>
<div class="container">
<?php if (is_active_sidebar('haun-ad-above-category')) { ?>
	<div class="a--d-wrapper" style="text-align: center; margin: 10px 0;">
		<?php dynamic_sidebar('haun-ad-above-category'); ?>
	</div>
<?php } ?>
	        <script>var haun_cfg = <?php echo json_encode($config, JSON_UNESCAPED_UNICODE); ?></script>
			<script>var haunrp_cfg = <?php echo json_encode($metarp, JSON_UNESCAPED_UNICODE); ?></script>
        	<h2 id="page-title" class="breadcrumb" style="text-transform: none;"><?php the_title(); ?></h2>
			<div id="video" data-id="<?php echo $post->ID; ?>">	
				<div class="desktop video-player" id="video-player"></div>
				<div id="video-actions">
					<?php echo haun_show_sv($post->ID, $server, $episode_slug, true); ?>
					<div class="video-stats" style="float:right">
						<?php 
							$like_count = (get_post_meta($post->ID, 'likes', true)) ? get_post_meta($post->ID, 'likes', true) : '0';
							$dislike_count = (get_post_meta($post->ID, 'dislikes', true)) ? get_post_meta($post->ID, 'dislikes', true) : '0';
							$total_votes = $like_count + $dislike_count;
							$percentage = ($total_votes == 0) ? 50 : ($like_count / $total_votes) * 100;
						?>
						<span id="report" class="haun-switch error"><span><?php _e('Report', 'haunthemes'); ?></span></span>
						<span class="likes" data-post-id="<?php echo $post->ID; ?>"><span id="like-count"><?php echo $like_count; ?></span></span>
						<span class="dislikes" data-post-id="<?php echo $post->ID; ?>"><span id="dislike-count"><?php echo $dislike_count; ?></span></span>
						<span class="rating"><span id="like-percentage"><?php echo round($percentage, 2); ?>%</span></span>
						<span class="views"><span><?php echo haun_display_post_view_count($post->ID, 'all') ?></span></span>
					</div>
				</div>
				<div class="clear"></div>
				<div class="video-info">
					<?php echo ($meta['haun_runtime']) ? '<span class="video-code">'.$meta['haun_runtime'].'</span>' : ''; ?>
					<span class="video-link"><?php echo parse_url(get_bloginfo('url'), PHP_URL_HOST) . '/' . $post->ID; ?></span>
				</div>
				<div class="video-content">
					<div class="video-description">
						<?php the_content(); ?>
					</div>
				<div class="video-tags">
					<div class="actress-tag">
						<?php
							$posttags = get_the_tags();
							if ($posttags) {
								foreach($posttags as $tag)
									echo '<a href="/tag/'.esc_html($tag->slug).'" title="'.esc_html($tag->name).'">'.esc_html($tag->name).'</a>';
							}
						?>
					</div>
					<div class="category-tag">
						<?php echo the_category( ' ' ); ?>
					</div>
				</div>
			</div>
		</div>
        <?php dynamic_sidebar('related-video'); ?>
		<?php if ( is_active_sidebar( 'haun-ad-below-category' ) ) { ?>
			<div class="a--d-wrapper" style="text-align: center; margin: 10px 0;">
				<?php dynamic_sidebar( 'haun-ad-below-category' ); ?>
			</div>
		<?php } ?>
</div>
<?php get_footer(); ?>